//
//  AEPAction.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "AliyunAction.h"
#import "AliyunWipeAction.h"
#import "AliyunMoveAction.h"
#import "AliyunSetAction.h"
#import "AliyunPartAction.h"

/**
 动画基类
 */
@interface AEPAction : NSObject

/**
 动画ID
 */
@property (nonatomic, assign, readonly) int actionId;

/**
 时间线上的开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineIn;
/**
 时间线上的结束时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineOut;


/**
 动画延迟时间 单位：秒.  API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineInOffset;

/**
 动画运行插值 @see AliyunActionInterpolator.  API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign, readonly) AliyunActionInterpolator actionInterpolator;

/**
 动画开始前是否可见 API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign, readonly) BOOL fillBefore;

/**
 动画结束后是否保持 API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign, readonly) BOOL fillAfter;

/**
 循环模式 @see AliyunActionRepeatMode API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign, readonly) AliyunActionRepeatMode repeatMode;

/**
 循环次数 API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign, readonly) int repeatCount;

/**
 子节点动画参数，仅当scope = AliyunActionScopePart 有效. API_AVAILABLE(3.25.0)
 */
@property (nonatomic, strong, readonly) NSDictionary *partParam;

/**
 * API_AVAILABLE(3.25.0)
 * 自定义动画的配置脚本，开发者可以自行配置每种动画在每一个时间刻度的具体动画值，以实现各种各样的变换速度
 * 配置脚本的格式是采用键值对，是以分号"；"为间隔的键值对列表，键就是时间刻度，值则分单值和双值，比如旋转角度这种只需要描述角度值，
 * 则使用单值，而像位移、缩放这种，需要x，y的值，则使用双值，双值的两个值之间用逗号"，"间隔，键和值之间以冒号"："间隔。
 * 举例：旋转角度变化的"0.0:0.123;0.1:0.245;0.3:0.798"。
 * 位移变化的"0.0:0.234,1.47;0.1:2.3,4.565;0.2:3.45,6.78"
 *
 * @param animationConfig 配置脚本
 */
@property (nonatomic, strong, readonly) NSString *animationConfig;

/**
 API_AVAILABLE(3.25.0)

 动画标识，标识业务层动画
 */
@property (nonatomic, copy, readonly) NSString *sourceId;


/**
 编辑器中的动画对象
 */
@property (nonatomic, strong, readonly) AliyunAction *editorAction;

@end


/**
 透明度动画
 */
@interface AEPAlphaAction : AEPAction

/**
 起始透明度
 */
@property (nonatomic, assign, readonly) float from;
/**
 终点透明度
 */
@property (nonatomic, assign, readonly) float to;

@end


/**
 缩放动画类
 */
@interface AEPScaleAction : AEPAction

/**
 缩放的起始缩放比例
 */
@property (nonatomic, assign, readonly) float from;
/**
 缩放的终点缩放比例
 */
@property (nonatomic, assign, readonly) float to;
/**
 是否启用缩放锚点，不开启则以物体自身中心点缩放
 */
@property (nonatomic, assign, readonly) BOOL scaleAnchorEnable;

/**
 缩放锚点：参考缩放基准值，用于计算trans偏移，默认为1.0
 */
@property (nonatomic, assign, readonly) float anchorBaseScale;
/**
 锚点坐标，[0,1]，默认值: (0.5, 0.5)
 */
@property (nonatomic, assign, readonly) CGPoint anchor;
@end


/**
 平移动画
 */
@interface AEPTranslateAction : AEPAction

/**
 移动的起始坐标

 坐标参考系是为系统屏幕坐标系 （0，0）为左上角  和系统view行为一致
 */
@property (nonatomic, assign, readonly) CGPoint from;
/**
 移动的终点位置
 */
@property (nonatomic, assign, readonly) CGPoint to;


/**
 动画移动类型 详情看 @AliyunMoveActionTranslateType，默认to
 */
@property(nonatomic, assign, readonly) AliyunMoveActionTranslateType translateType;



@end

/**
 旋转动画的基类
 */
@interface AEPRotateBaseAction : AEPAction
/**
 旋转方向

 可以设置为顺时针或者逆时针
 true:顺时针
 false:逆时针
 */
@property (nonatomic, assign, readonly) BOOL  clockwise;
/**
 开始旋转时的弧度

 单位：弧度
 */
@property (nonatomic, assign, readonly) float from;

/**
 旋转的中心点，取值[0,1]
 */
@property(nonatomic, assign, readonly) CGPoint normalizedCenter;

/**
 旋转中心点所在的坐标系统，默认为AliyunActionCoordinateSpace_Local
 */
@property(nonatomic, assign, readonly) AliyunActionCoordinateSpace coordinateSpace;
@end


/**
 旋转到某个角度类

 继承自AliyunRotateAction
 */
@interface AEPRotateToAction : AEPRotateBaseAction
/**
 旋转到目标角度
 */
@property (nonatomic, assign, readonly) float to;
@end


/**
 旋转动画类
 */
@interface AEPRotateByAction : AEPRotateBaseAction

/**
 在当前的旋转弧度上再旋转多少弧度
 */
@property (nonatomic, assign, readonly) float rotate;

@end

/**
 重复旋转类 不停地旋转
 */
@interface AEPRotateRepeatAction : AEPRotateBaseAction
/**
 旋转一圈需要的时间
 */
@property (nonatomic, assign, readonly) float durationPerCircle;
/**
 是否重复；默认YES
 */
@property (nonatomic, assign, readonly) BOOL  repeat;

@end

/**
 线性擦除动画
 */
@interface AEPWipeAction : AEPAction

/**
 线性擦除方向
 */
@property (nonatomic, assign, readonly) AliWipeActionDirection direction;
/**
 擦除模式
 */
@property (nonatomic, assign, readonly) AliWipeActionMode wipeMode;

@end

/**
 自定义动画
 */
@interface AEPCustomAction : AEPAction

/**
 自定义动画的片元着色器代码
 */
@property (nonatomic, copy, readonly) NSString *fragmentShader;

/**
 自定义动画的顶点着色器代码
 */
@property (nonatomic, copy, readonly) NSString *vertexShader;


/**
 片元着色器的参数设置：为字典结构
 */
@property (nonatomic, copy, readonly) NSDictionary *uniforms;

@end


/**
 组动画
 */
@interface AEPSetAction : AEPAction


/**
 动画集合中的动画执行方式 @see AliyunSetActionPlayMode. API_AVAILABLE(3.25.0)
 */
@property(nonatomic, assign, readonly) AliyunSetActionPlayMode subSetMode;

/**
 动画组，包含AliyunAction动画 API_AVAILABLE(3.25.0)
 */
@property(nonatomic, copy, readonly) NSArray<AEPAction *> *subList;

@end


@interface AEPPartAction : NSObject

@property (nonatomic, strong, readonly)AliyunPartAction *nativePartAction;

- (instancetype)initWithNativePartAction:(AliyunPartAction *)nativePartAction;

@end
