//
//  AliyunTemplateBuilder.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/11/9.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunTemplate.h"
#import "AliyunEditor.h"

/**
 生成模板节点内容调整对象
 API_AVAILABLE(3.27.0)
 */
@interface AliyunTemplateModifyContent : NSObject

/**
 替换节点标识
 */
@property (nonatomic, strong, readonly) NSString *nodeKey;

/**
 节点内容，必须是AEPBaseVideoTrackClip 或  AEPCaptionBaseTrack
 */
@property (nonatomic, strong, readonly) id content;

/**
 替换节点内容是否被锁定
 */
@property (nonatomic, assign) BOOL lockContent;

@end



/**
 模板生成器
 API_AVAILABLE(3.27.0)
 */
@interface AliyunTemplateBuilder : NSObject

/**
 生成模板
 
 @param taskPath 生成目录，如果存在则会删除后重新创建
 @param editor 编辑器
 @return AliyunTemplateBuilder
 */
+ (AliyunTemplateBuilder *)build:(NSString *)taskPath editor:(AliyunEditor *)editor;

/**
 生成模板
 
 @param taskPath 生成目录
 @param editorTaskPath 编辑器TaskPath
 @return AliyunTemplateBuilder
 */
+ (AliyunTemplateBuilder *)build:(NSString *)taskPath editorTaskPath:(NSString *)editorTaskPath;


/**
 获取当前TaskPath

 @return 当前TaskPath
 */
- (NSString *)getTaskPath;

/**
 获取当前Template

 @return 当前AliyunTemplate
 */
- (AliyunTemplate *)getTemplate;

/**
 获取所有待修改列表

 @return AliyunTemplateModifyContent类型的列表
 */
- (NSArray<AliyunTemplateModifyContent *> *)getModifyContentList;


/**
 更新模板id
 @param templateId  模板id
 @return 成功或失败
 */
- (BOOL)updateTemplateId:(NSString *)templateId;

/**
 更新模板标题
 @param title 标题
 @return 成功或失败
 */
- (BOOL)updateTitle:(NSString *)title;

/**
 更新模板封面，支持http和本地路径
 http地址会记录到URL中
 本地地址会拷贝文件到TaskPath目录下，并把新路径记录在path中
 @param coverUrl 封面地址
 @return 成功或失败
 */
- (BOOL)updateCover:(NSString *)coverUrl;

/**
 更新模板预览视频地址，支持http和本地路径
 http地址会记录到URL中
 本地路径会拷贝文件到TaskPath目录下，并把新路径记录在path中
 @param videoUrl 预览视频地址
 @return 成功或失败
 */
- (BOOL)updatePreviewVideo:(NSString *)videoUrl;

/**
 更新模板参数
 @param modifyContent 节点调整对象
 @return 成功或失败
 */
- (BOOL)updateParam:(AliyunTemplateModifyContent *)modifyContent;

/**
 保存
 @return 成功或失败
 */
- (BOOL)save;

@end
