//
//  AliyunAETemplateNode.h
//  AlivcUgsvDemo
//
//  Created by Bingo on 2022/9/22.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 AE设计时指定的素材播放时间
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplateAssetTimeRange : NSObject

/**
 开始时间
 */
@property (nonatomic, assign) NSTimeInterval timelineIn;

/**
 结束时间
 */
@property (nonatomic, assign) NSTimeInterval timelineOut;

@end


/**
 模板素材
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplateAsset : NSObject

/**
 key
 */
@property (nonatomic, copy, readonly) NSString *key;

/**
 索引
 */
@property (nonatomic, assign, readonly) NSInteger index;

/**
 播放时间段，可能出现多次
 */
@property (nonatomic, copy, readonly) NSArray<AliyunAETemplateAssetTimeRange *> *timeRanges;

/**
 素材出现时长，通过对timeRanges的每个时间段进行累加计算
 */
@property (nonatomic, assign, readonly) NSTimeInterval duration;


/**
 素材在AE编辑时指定的渲染区域
 */
@property (nonatomic, assign, readonly) CGRect editRect;

/**
 素材在AE编辑执行变换指定的锚点[0.1]，默认[0.5, 0.5]
 */
@property (nonatomic, assign, readonly) CGPoint editAnchor;

/**
 素材在AE编辑时指定的变换
 */
@property (nonatomic, assign, readonly) CGAffineTransform editTransform;


@end


/**
 媒体型的模板素材（视频或图片）
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplateAssetMedia : AliyunAETemplateAsset

/**
 素材名字
 */
@property (nonatomic, copy, readonly) NSString *assetName;

/**
 替换路径，需要调用AliyunAETemplateEditor::commit才能生效
 */
@property (nonatomic, copy, nullable) NSString *replacedPath;

@end

/**
 文字型模板素材
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplateAssetText : AliyunAETemplateAsset

/**
 渲染文本
 */
@property (nonatomic, copy, readonly) NSString *text;

/**
 文本最大长度
 */
@property (nonatomic, assign, readonly) NSUInteger maxLength;

/**
 替换文本，需要调用AliyunAETemplateEditor::commit才能生效
 */
@property (nonatomic, copy, nullable) NSString *replacedText;

@end

NS_ASSUME_NONNULL_END
