//
//  AVPConfig.h
//  AliPlayerSDK
//
//  Created by shiping.csp on 2018/11/16.
//  Copyright © 2018 com.alibaba.AliyunPlayer. All rights reserved.
//

#ifndef AVPConfig_h
#define AVPConfig_h

#import <Foundation/Foundation.h>

OBJC_EXPORT
@interface AVPConfig : NSObject

/**
 @brief 直播最大延迟 默认5000毫秒，单位毫秒
 */
@property (nonatomic, assign) int maxDelayTime;

/**
 @brief 卡顿后缓存数据的高水位，当播放器缓存数据大于此值时开始播放，单位毫秒
 */
@property (nonatomic, assign) int highBufferDuration;

/**
 @brief 开始起播缓存区数据长度，默认500ms，单位毫秒
 */
@property (nonatomic, assign) int startBufferDuration;

/**
 @brief 播放器最大的缓存数据长度，默认50秒，单位毫秒
 */
@property (nonatomic, assign) int maxBufferDuration;

/**
 @brief 网络超时时间，默认15秒，单位毫秒
 */
@property (nonatomic, assign) int networkTimeout;

/**
 @brief 网络重试次数，每次间隔networkTimeout，networkRetryCount=0则表示不重试，重试策略app决定，默认值为2
 */
@property (nonatomic, assign) int networkRetryCount;

/**
 @brief probe数据大小，默认-1,表示不设置
 */
@property (nonatomic, assign) int maxProbeSize;

/**
 @brief 请求referer
 */
@property (nonatomic, copy) NSString *referer;

/**
 @brief user Agent
 */
@property (nonatomic, copy) NSString *userAgent;

/**
 @brief httpProxy代理
 */
@property (nonatomic, copy) NSString *httpProxy;

/**
 @brief 调用stop停止后是否显示最后一帧图像，YES代表清除显示，黑屏，默认为NO
 */
@property (nonatomic, assign) BOOL clearShowWhenStop;

/**
 @brief 添加自定义header
 */
@property (nonatomic, copy) NSMutableArray *httpHeaders;

/**
 @brief 是否启用SEI
 */
@property (nonatomic, assign) BOOL enableSEI;

/**
 @brief 是否开启本地缓存
 */
@property(nonatomic, assign) BOOL enableLocalCache;

/* set the video format for renderFrame callback
 * vtb decoder only, equal to OSType, not be supported by other decoder
  * support 420v 420f y420 BGRA
* */
@property (nonatomic, assign) int pixelBufferOutputFormat;
/**
 @brief  HLS直播时，起播分片位置。
 */
@property(nonatomic, assign) int liveStartIndex;
/**
 @brief 禁用Audio.
 */
@property (nonatomic, assign) BOOL disableAudio;

/**
 @brief 禁用Video
 */
@property (nonatomic, assign) BOOL disableVideo;

/**
@brief  进度跟新的频率。包括当前位置和缓冲位置。
 */
@property(nonatomic, assign) int positionTimerIntervalMs;

/**
 @brief 设置播放器后向buffer的最大值.
 */
@property(nonatomic, assign) uint64_t mMAXBackwardDuration;


/**
 @brief 优先保证音频播放；在网络带宽不足的情况下，优先保障音频的播放，目前只在dash直播流中有效（视频已经切换到了最低码率）
 */
@property (nonatomic, assign) BOOL preferAudio;

/**
 @brief 播放器实例是否可以使用http dns进行解析，-1 表示跟随全局设置，0 disable
 */
@property(nonatomic, assign) int enableHttpDns;

/**
 @brief 使用http3进行请求，支持标准：RFC 9114（HTTP3）和RFC 9000（QUIC v1），默认值关。如果http3请求失败，自动降级至普通http，默认关闭
 */
@property(nonatomic, assign) BOOL enableHttp3;

/**
 @brief 用于纯音频或纯视频的RTMP/FLV直播流起播优化策略，当流的header声明只有音频或只有视频时，且实际流的内容跟header声明一致时，此选项打开可以达到快速起播的效果。默认关闭
 */
@property(nonatomic, assign) BOOL enableStrictFlvHeader;

/**
 @brief 针对打开了点播URL鉴权的媒体资源（HLS协议），开启本地缓存后，可选择不同的鉴权模式：非严格鉴权(false)：鉴权也缓存，若上一次只缓存了部分媒体，下次播放至非缓存部分时，播放器会用缓存的鉴权发起请求，如果URL鉴权设置的有效很短的话，会导致播放异常。严格鉴权(true)：鉴权不缓存，每次起播都进行鉴权，无网络下会导致起播失败。默认值：false。
 */
@property(nonatomic, assign) BOOL enableStrictAuthMode;

@end

#endif /* AVPConfig_h */
