//
//  AliyunTemplate.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/11/9.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPSource.h"


/**
 模板参数
 API_AVAILABLE(3.27.0)
 */
@interface AliyunTemplateParam : NSObject

/**
 替换节点标识
 */
@property (nonatomic, copy, readonly) NSString *nodeKey;

/**
 替换节点是否被锁定
 */
@property (nonatomic, assign, readonly, getter=isLock) BOOL lock;

@end


/**
 模板
 API_AVAILABLE(3.27.0)
 */
@interface AliyunTemplate : NSObject

/**
 当前SDK的模板版本号
 */
@property (nonatomic, class, readonly) int CurrentVersion;

/**
 模板文件的版本号
 */
@property (nonatomic, assign, readonly) int version;

/**
 模板ID，由模板生成确定，默认为空
 */
@property (nonatomic, copy, readonly) NSString *templateId;

/**
 标题
 */
@property (nonatomic, copy, readonly) NSString *title;

/**
 工程文件路径
 */
@property (nonatomic, strong, readonly) AEPSource *project;

/**
 封面图路径
 */
@property (nonatomic, strong, readonly) AEPSource *cover;

/**
 预览视频路径
 */
@property (nonatomic, strong, readonly) AEPSource *previewVideo;



/**
 模板参数列表
 */
@property (nonatomic, copy, readonly) NSArray<AliyunTemplateParam *> *params;


@end
