//
//  AliyunTemplateNode.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/11/15.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPVideoTrackClip.h"
#import "AEPStickerTrack.h"

/**
 模板应用节点
 API_AVAILABLE(3.27.0)
 */
@interface AliyunTemplateNode : NSObject


/**
 替换节点标识
 */
@property (nonatomic, copy, readonly) NSString *nodeKey;

/**
 替换节点内容是否被锁定
 */
@property (nonatomic, assign, readonly, getter=isLock) BOOL lock;

/**
 开始时间
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineIn;

/**
 结束时间
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineOut;

/**
 位置与大小
 */
@property (nonatomic, assign, readonly) CGRect frame;

/**
 旋转
 */
@property (nonatomic, assign, readonly) float rotation;

/**
 信息
 */
@property (nonatomic, copy, readonly) NSString *info;

@end

/**
 模板应用片段节点
 API_AVAILABLE(3.27.0)
 */
@interface AliyunTemplateClipNode : AliyunTemplateNode

/**
 片段
 */
@property (nonatomic, strong, readonly) AEPBaseVideoTrackClip *clip;

@end


/**
 模板应用字幕节点
 API_AVAILABLE(3.27.0)
 */
@interface AliyunTemplateCaptionNode : AliyunTemplateNode

/**
 字幕
 */
@property (nonatomic, strong, readonly) AEPCaptionBaseTrack *captionTrack;

@end
