//
//  AliyunAETemplate.h
//  AlivcUgsvDemo
//
//  Created by Bingo on 2022/10/10.
//

#import <UIKit/UIKit.h>
#import "AliyunAETemplateAsset.h"

NS_ASSUME_NONNULL_BEGIN

/**
 可替换素材在预览画面上的顶点信息
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplateAssetVertexs : NSObject

/**
 左上点top-left
 */
@property (nonatomic, assign, readonly) CGPoint tl;

/**
 右上点top-right
 */
@property (nonatomic, assign, readonly) CGPoint tr;

/**
 右下点bottom-right
 */
@property (nonatomic, assign, readonly) CGPoint br;

/**
 左下点bottom-left
 */
@property (nonatomic, assign, readonly) CGPoint bl;


@end

/**
 AE模板
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplate : NSObject

/**
 初始化模板，打开一个已有模板素材

 @param path 模板素材文件夹路径
 @return AliyunAETemplate
 */
- (instancetype)initWithPath:(NSString *)path;

/**
 模板文件夹路径
 */
@property (nonatomic, copy, readonly) NSString *path;

/**
 模板输出分辨率
 */
@property (nonatomic, assign, readonly) CGSize outputSize;

/**
 模板中可替换素材列表
 */
@property (nonatomic, copy, readonly) NSArray<AliyunAETemplateAsset *> *replaceableAssets;

/**
 模板背景音乐路径
 */
@property (nonatomic, copy, readonly) NSString *musicPath;

/**
 替换的背景音乐路径，AliyunAETemplateEditor::replaceAudio:调用成功后可在获取
 */
@property (nonatomic, copy, readonly) NSString *replacedMusicPath;


/**
 获取指定素材在当前预览中的顶点信息

 @param asset 指定素材
 @return 多个顶点数组，可能在画幅中出现多个位置
 */
- (NSArray<AliyunAETemplateAssetVertexs *> *)fetchAssetDrawingVertexs:(AliyunAETemplateAsset *)asset;

@end

NS_ASSUME_NONNULL_END
