//
//  AliyunFileRecordSource.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/4/28.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AliyunRecordSource.h"
#import "AliyunVideoRecordController.h"
#import "AliyunAudioRecordController.h"

/**
 文件录制源 API_AVAILABLE(3.39.0)
 */
/****
 The source of file API_AVAILABLE(3.29.0)
 */
@interface AliyunFileRecordSource : NSObject<AliyunRecordFileSource>

/**
 初始化音频文件源
 @param filePath 音频文件路径
 @param startTime 开始截取音频片段的时间
 @param duration 截取音频片段时长
 */
/****
 Init audio file source
 @param filePath The path of audio path
 @param startTime startTime of audio clip
 @param duration duration of audio clip
 */
- (instancetype) initWithAudioFilePath:(NSString *)filePath
                             startTime:(NSTimeInterval)startTime
                              duration:(NSTimeInterval)duration;

/**
 初始化音视频文件源
 @param filePath 音视频文件源
 @param startTime 开始截取音视频片段时间
 @param duration 截取音视频片段时长
 */
/****
 Init av file source
 @param filePath The path of av path
 @param startTime startTime of av clip
 @param duration duration of av clip
 */
- (instancetype) initWithAVFilePath:(NSString *)filePath
                          startTime:(NSTimeInterval)startTime
                           duration:(NSTimeInterval)duration;
@end

/**
 AV文件源控制器 API_AVAILABLE(3.39.0)
 */
/****
 The Controller of AVFileSource API_AVAILABLE(3.39.0)
 */
@protocol AliyunAVFileRecordController<AliyunVideoBaseRecordController, AliyunAudioRecordController>
/**
 预览视图 API_AVAILABLE(3.28.0)
 必须设置
 */
/****
 preview API_AVAILABLE(3.29.0)
 must be setup
 */
@property (nonatomic, weak) UIView *preview;
/**
 AV文件源
 */
/****
 The source of avFile
 */
@property (nonatomic, readonly) AliyunFileRecordSource *avFile;
@end
