//
//  AliyunVideoParam.h
//  AliyunVideo
//
//  Created by Worthy on 2017/3/21.
//  Copyright (C) 2010-2017 Alibaba Group Holding Limited. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 输出视频质量

 - AliyunVideoQualityVeryHight: VeryHight
 - AliyunVideoQualityHight: Hight
 - AliyunVideoQualityMedium: Medium
 - AliyunVideoQualityLow: Low
 - AliyunVideoQualityPoor: Poor
 - AliyunVideoQualityExtraPoor: ExtraPoor
 */
typedef NS_ENUM(NSInteger, AliyunVideoQuality) {
    AliyunVideoQualityVeryHight,
    AliyunVideoQualityHight,
    AliyunVideoQualityMedium,
    AliyunVideoQualityLow,
    AliyunVideoQualityPoor,
    AliyunVideoQualityExtraPoor
};

/**
 裁剪模式

 - AliyunScaleModeFit: 裁剪
 - AliyunScaleModeFill: 填充
 */
typedef NS_ENUM(NSInteger, AliyunScaleMode) {
    AliyunScaleModeFit = 0,
    AliyunScaleModeFill = 1
};

/**
 内容模式
 
 - AlivcContentModeScaleAspectFit: 填充模式
 - AlivcContentModeScaleAspectFill: 裁剪模式
 */
typedef NS_ENUM(NSInteger, AlivcContentMode) {
    AlivcContentModeScaleAspectFit = 1,
    AlivcContentModeScaleAspectFill = 0,
};

/**
 编码器类型

 ios只开放部分编码类型
 - AliyunVideoCodecTypeAuto: 自动
 - AliyunVideoCodecHardware: 硬编
 - AliyunVideoCodecOpenh264: Openh264
 
 - AliyunVideoCodecFFmpeg: ffmpeg, 当前版本(v3.23.0之后)不再使用
 - AliyunVideoCodecX264: X264, 当前版本(v3.23.0之后)不再使用
 */
typedef NS_ENUM(NSInteger, AliyunVideoCodecType) {
    AliyunVideoCodecTypeAuto = 0,
    AliyunVideoCodecHardware = 1, 
    AliyunVideoCodecOpenh264 = 3,

};

/**
合拍背景图裁剪模式
 
 - AliyunMixVideoBackgroundImageModeScaleAspectFill: 按图片比例填充
 - AliyunMixVideoBackgroundImageModeScaleAspectFit: 按图片比例适配
 - AliyunMixVideoBackgroundImageModeScaleToFill: 填充
 */
typedef NS_ENUM(NSInteger, AliyunMixVideoBackgroundImageMode) {
    AliyunMixVideoBackgroundImageModeScaleAspectFill,
    AliyunMixVideoBackgroundImageModeScaleAspectFit,
    AliyunMixVideoBackgroundImageModeScaleToFill,
};

/**
 音频声道数
 
 - AliyunAudioChannelTypeMono: 单声道
 - AliyunAudioChannelTypeStereo: 立体声
 */
typedef NS_ENUM(NSUInteger, AliyunAudioChannelType) {
    AliyunAudioChannelTypeMono      = 1,
    AliyunAudioChannelTypeStereo    = 2,
};

/**
 音频采样率
 
 - AliyunAudioSampleRate8K:   8K
 - AliyunAudioSampleRate12K: 12K
 - AliyunAudioSampleRate16K: 16K
 - AliyunAudioSampleRate24K: 24K
 - AliyunAudioSampleRate32K: 32K
 - AliyunAudioSampleRate44_1K: 44.1K
 - AliyunAudioSampleRate48K: 48K
 - AliyunAudioSampleRate64K: 64K
 - AliyunAudioSampleRate88_2K: 88.2K
 - AliyunAudioSampleRate96K: 96K
 */
typedef NS_ENUM(NSUInteger, AliyunAudioSampleRate) {
    AliyunAudioSampleRate8K         = 8000, // 8K
    AliyunAudioSampleRate12K        = 12000, // 12K
    AliyunAudioSampleRate16K        = 16000, // 16K
    AliyunAudioSampleRate24K        = 24000, // 24K
    AliyunAudioSampleRate32K        = 32000, // 32K
    AliyunAudioSampleRate44_1K      = 44100, // 44.1K
    AliyunAudioSampleRate48K        = 48000, // 48K
    AliyunAudioSampleRate64K        = 64000, // 64K
    AliyunAudioSampleRate88_2K      = 88200, // 88.2K
    AliyunAudioSampleRate96K        = 96000, // 96K
};

/**
 视频参数设置类
 */
@interface AliyunVideoParam : NSObject

/**
 帧率

 默认25 建议20 - 60 不超过60
 */
@property(nonatomic, assign) int fps;

/**
 关键帧间隔

 gop > 1
 默认值75: 25(默认fps) * 3: 3秒
 */
@property(nonatomic, assign) int gop;

/**
 码率

 单位bps 建议：
 480P:1000000-2000000
 540P:2000000-3000000
 720P:2000000-4000000
 1080:2000000-6000000
 设置bitrate参数后，videoQuality设置无效
 */
@property(nonatomic, assign) int bitrate;

/**
 视频质量
 */
@property(nonatomic, assign) AliyunVideoQuality videoQuality;

/**
 裁剪或者填充模式
 */
@property(nonatomic, assign) AliyunScaleMode scaleMode;

/**
 编码类型
 */
@property(nonatomic, assign) AliyunVideoCodecType codecType;

/**
 音频声道数
 */
@property(nonatomic, assign) AliyunAudioChannelType audioChannel;

/**
 音频采样率
 */
@property(nonatomic, assign) AliyunAudioSampleRate audioSampleRate;

/**
 创建一个AliyunVideoParam对象，并设置为默认属性

 @return AliyunVideoParam对象
 */
+ (instancetype)defaultVideoParam;

@end
