//
//  AlivcLivePushDef.h
//  AlivcLivePusher
//
//  Created by siheng on 2022/7/25.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "AlivcLivePushConstants.h"

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 音频裸数据
 */

@interface AlivcLivePusherAudioDataSample : NSObject

@property (nonatomic, assign) long dataPtr;//强制转换成(uint8_t*)dataPtr即为PCM数据buffer内存首地址 Forcefully converted to (uint8_t*)dataPtr, which is the memory address of the PCM data buffer
@property (nonatomic, assign) int numOfSamples;//数据总大小为numOfSamples*bytesPerSample Total data size numOfSamples*bytesPerSample
@property (nonatomic, assign) int bytesPerSample;
@property (nonatomic, assign) int numOfChannels;
@property (nonatomic, assign) int samplesPerSec;

@end

/**
 * @brief 直播连麦播放参数配置
 */

@interface AlivcLivePlayConfig : NSObject
/**
 * @brief 渲染模式
 * default：AlivcLivePlayRenderModeAuto
 */

@property (nonatomic) AlivcLivePlayRenderMode renderMode;

/**
 * @brief 播放是否镜像
 * default：false，非镜像
 */

@property (nonatomic, assign) BOOL mirror;

/**
 * @brief 旋转角度
 * default： AlivcLivePlayRotationMode_0
 */

@property (nonatomic, assign) AlivcLivePlayRotationMode rotationMode;

/**
 * @brief 视频流类型
 * default: AlivcLivePlayVideoStreamTypeCamera
 */

@property (nonatomic, assign) AlivcLivePlayVideoStreamType videoStreamType;
@end


/**
 * 云端混流（转码）中每一路子画面的位置信息
 */

@interface AlivcLiveMixStream : NSObject

/**
 参与混流的 userId
 备注：和推拉地址中userId字端相同
 */

@property (nonatomic, copy, nonnull) NSString *userId;

/**
 * 图层位置 x 坐标（绝对像素值）
 */

@property (nonatomic, assign) int x;

/**
 * 图层位置 y坐标（绝对像素值）
 */

@property (nonatomic, assign) int y;

/**
 * 图层宽度（绝对像素值）
 */

@property (nonatomic, assign) int width;

/**
 * The height of the layer (absolute pixels).
 */
@property (nonatomic, assign) int height;
/**
 *  图层层次（1 - 15）不可重复
 */

@property (nonatomic, assign) int zOrder;

/**
 * 混入的流类型
 */

@property (nonatomic, assign) AlivcLiveMixStreamType streamType;

/**
 * 混入的流类型
 */

@property (nonatomic, assign) AlivcLiveMixSourceType sourceType;

@end

/**
 * 云端混流（转码）配置
 */

@interface AlivcLiveTranscodingConfig : NSObject

/**
 * 混合后画面的底色颜色，默认为黑色，格式为十六进制数字,0xRRGGBB
 * 默认：0x000000
 */

@property (nonatomic, assign) int backgroundColor;

/**
 * 混合后视频画面裁剪模式
 * 默认：AlivcLiveTranscodingCropModeCrop
 */

@property (nonatomic, assign) AlivcLiveTranscodingCropMode cropMode;


@property (nonatomic, strong, nonnull) NSArray<AlivcLiveMixStream *> *mixStreams;

@end

@interface AlivcLiveVideoDataSample : NSObject

@property (nonatomic, assign) AlivcLivePushVideoFormat format;
@property (nonatomic, assign) AlivcLiveBufferType type;
@property (nonatomic, assign) CVPixelBufferRef _Nullable pixelBuffer;
@property (nonatomic, assign) long dataPtr;
@property (nonatomic, assign) long dataYPtr;
@property (nonatomic, assign) long dataUPtr;
@property (nonatomic, assign) long dataVPtr;
@property (nonatomic, assign) long dataLength;
@property (nonatomic, assign) int strideY;
@property (nonatomic, assign) int strideU;
@property (nonatomic, assign) int strideV;
@property (nonatomic, assign) int stride;
@property (nonatomic, assign) int height;
@property (nonatomic, assign) int width;
@property (nonatomic, assign) int rotation;
@property (nonatomic, assign) long long timeStamp;
@property (nonatomic, assign) int encodeCostMs;

@end

@interface AlivcLivePlayerStatsInfo : NSObject

#pragma mark - system
/**
 用户ID
 */

@property (nonatomic, copy) NSString * _Nonnull userId;

/**
 视频宽度
 */

@property(nonatomic, assign) int videoWidth;

/**
 视频高度
 */

@property(nonatomic, assign) int videoHeight;

/**
 视频解码FPS
 * 单位 : Frames per Second
 */

@property (nonatomic, assign) int decodeFps;

/**
 视频渲染FPS
 * 单位 : Frames per Second
 */

@property (nonatomic, assign) int renderFps;

/**
 视频码率（当前视频码率是所有接收的总码率）
 * Kbps
 */

@property (nonatomic, assign) int videoBitrate;


/**
 音频码率
 * Kbps
 */

@property (nonatomic, assign) int audioBitrate;


/**
 音频丢包率
 * %
 */

@property (nonatomic, assign) int audioLossRate;;

/**
 丢包率 (网络丢包率)
 * %
 */

@property (nonatomic, assign) int lossRate;


@end


@interface AlivcLiveLocalRecoderConfig : NSObject

/**
 * 录音文件在本地保存的绝对路径，需精确到文件名及格式（必填）。请确保路径有读写权限且合法，否则录制文件无法生成。
 * 该路径需要精确到文件名及格式后缀，格式后缀用于决定录制出的文件格式。
 * 例如 /App Sandbox/Library/Caches/local.mp4, 请确保你指定的路径存在并且可写, 目前支持的视频录制格式只有MP4。
 */
@property (nonatomic, copy) NSString *_Nonnull storagePath;


/**
 * 媒体录制类型，默认是AlivcLiveRecordTypeAudioAndVideo， 即同时录制音频和视频
 */
@property (nonatomic, assign) AlivcLiveRecordType recordType;

/**
 * 录制视频最大文件长度，单位：字节，默认是0
 * 1. 如果设置为0或者-1，SDK内部按照2G大小进行分块，录制文件超过2G则回调相应事件，并在设置的文件尾上追加块编号重新在新的文件上进行录制；
 * 2. 如果设置了>0的值，则发现文件超过该值后停止录制，同时在onMediaRecordEvent回调消息；
 * 如果需要控制录制文件大小，可以设置该字段
 * 注：该字段只有在recordType=AlivcLiveRecordTypeAudioAndVideo，即需要生成AlivcLiveRecordFormatMP4格式的Mp4文件时生效；如果recordType=AlivcLiveRecordTypePureAudio，设置该字段无效
 */
@property (nonatomic, assign) NSInteger maxSize;

/**
 * 录制视频最大时长, 单位：秒，默认是0
 * 如果等于0或者小于0，则不对录制时长做限制
 * 如果设置了时间长度限制，则超过限制时长停止录制，同时onMediaRecordEvent回调消息；
 * 如果需要控制录制文件时长，可以设置该字段
 * 注：该字段只有在recordType=AlivcLiveRecordTypeAudioAndVideo，即需要生成AlivcLiveRecordFormatMP4格式的Mp4文件时生效；如果recordType=AlivcLiveRecordTypePureAudio，设置该字段无效
 */
@property (nonatomic, assign) NSInteger maxDuration;

/**
 * 录制音频的质量，详见 AlivcLiveRecordAudioQuality
 * 默认：AlivcLiveRecordAudioQualityMidium
 */
@property (nonatomic, assign) AlivcLiveRecordAudioQuality recordAudioQuality;

/**
 * 录制格式，默认：AlivcLiveRecordFormatMP4
 * 注：如果record指定为AlivcLiveRecordTypePureAudio，则recordFormat不能指定为AlivcLiveRecordFormatMP4；
 *   如果record指定为AlivcLiveRecordTypeAudioAndVideo，则recordFormat需要指定为AlivcLiveRecordFormatMP4；
 */
@property (nonatomic, assign) AlivcLiveRecordFormat recordFormat;

/**
 * 录制音频的采样率，默认：AlivcLivePushAudioSampleRate48000
 */
@property (nonatomic, assign) AlivcLivePushAudioSampleRate recordAudioSamplerate;

@end

NS_ASSUME_NONNULL_END
