//
//  AliyunTemplateLoader.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/11/18.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunTemplateResource.h"
#import "AliyunTemplate.h"

/**
 模板加载器，对builder之后的模板目录进行加载后得到模板对象，及导入编辑资源
 API_AVAILABLE(3.27.0)
 */
@interface AliyunTemplateLoader : NSObject

/**
 初始化，通过模板目录加载模板

 @param taskPath 模板目录
 @return AliyunTemplateLoader
 */
- (instancetype)initWithTaskPath:(NSString *)taskPath;

/**
 获取当前TaskPath

 @return 当前TaskPath
 */
- (NSString *)getTaskPath;

/**
 获取当前Template

 @return 当前AliyunTemplate
 */
- (AliyunTemplate *)getTemplate;

/**
 加载模板编辑器工程资源
 @param resImport  工程文件资源导入器
 @param completedHandler  回调
 @return 成功或失败
 */
- (BOOL)loadProject:(AliyunResourceImport *)resImport completed:(void(^)(NSError *error))completedHandler;

@end
