//
//  QueenMaterial.h
//  queen
//
//  Created by zhangjc on 2022/6/30.
//  Copyright © 2022 alibabaAliyun. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/** 资源类型
 */
typedef NS_ENUM(NSUInteger, kQueenMaterialType) {
    /** 模型资源
     */
    kQueenMaterialModel = 0,
    /** 贴纸
     */
    kQueenMaterialSticker,
    /** 滤镜
     */
    kQueenMaterialLUT,
    /** 美妆
     */
    kQueenMaterialMakeup,
    /** 背景
     */
    kQueenMaterialBackground
};

@protocol QueenMaterialDelegate <NSObject>

@optional

/**
 * 资源下载完成的回调。
 * @param type 资源类型。
 */
- (void)queenMaterialOnReady:(kQueenMaterialType)type;

/**
 * 资源下载进度的回调。
 * @param currentSize 已下载的资源大小。
 * @param totalSize 需要下载资源的总大小。
 * @param type 资源类型。
 */
- (void)queenMaterialOnProgress:(kQueenMaterialType)type withCurrentSize:(int)currentSize withTotalSize:(int)totalSize withProgess:(float)progress;

/**
 * 资源下载错误的回调，应该检查网络与磁盘空间是否出现问题。
 * @param type 资源类型。
 */
- (void)queenMaterialOnError:(kQueenMaterialType)type;

@end

@interface QueenMaterial : NSObject

/** QueenMaterial回调代理对象。
 */
@property (nonatomic, weak) id <QueenMaterialDelegate> delegate;

/** QueenMaterial的通用对象。
 */
+ (instancetype)sharedInstance;

/** 获取已下载好的资源路径。
 * @param type 资源类型。
 * @return 资源路径。
 */
- (NSString *)getMaterialPath:(kQueenMaterialType)type;

/** 请求下载资源包。
 * @param type 资源类型。
 * @return 资源是否需要下载。
 */
/** Request to download resource package.
 * @param type materialType.
 * @return Whether the resource need to be downloaded.
 */
- (BOOL)requestMaterial:(kQueenMaterialType)type;

/**
 * 设置自定义资源包链接，必须先于资源下载的请求。
 * @param type 资源类型。
 * @param materialURL 资源的下载地址。
 */
- (void)setMaterialURL:(kQueenMaterialType)type withURL:(NSString *)materialURL;

@end

NS_ASSUME_NONNULL_END
