//
//  AliyunLutFilter.h
//  AliyunVideoSDKPro
//
//  Created by mengyehao on 2021/11/15.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AliyunBaseFilter.h"

NS_ASSUME_NONNULL_BEGIN

/**
 API_AVAILABLE(3.27.0)
 lut滤镜数据model
 */
@interface AliyunLutFilter : AliyunBaseFilter

/**
 API_AVAILABLE(3.27.0)
 lut滤镜图片的路径
 */
@property(nonatomic, copy, readonly) NSString *path;

/**
 API_AVAILABLE(3.27.0)
 lut滤镜强度，范围[0.0,1.0]，默认1.0
 */
@property(nonatomic, assign) float intensity;

/**
 API_AVAILABLE(3.27.0)
 初始化方法
 
 @param path lut滤镜图片的路径
 @return AliyunLutFilter，lut滤镜数据model
 */
- (instancetype)initWithPath:(NSString *)path;

@end

NS_ASSUME_NONNULL_END
