//
//  AEPConfig.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunVideoParam.h"
#import <UIKit/UIKit.h>

/**
 工程配置
 */
@interface AEPConfig : NSObject

/**
 两个I帧之间的间隔，GOP大小
 */
@property (nonatomic, assign, readonly) int GOP;

/**
 视频质量
 */
@property (nonatomic, assign, readonly) AliyunVideoQuality videoQuality;

/**
 码率

 单位bps 建议：
 480P:1000000-2000000
 540P:2000000-3000000
 720P:2000000-4000000
 1080:2000000-6000000
 设置bitrate参数后，videoQuality设置无效
 */
@property (nonatomic, assign, readonly) int bitrate;

/**
 帧率

 默认25 建议20 - 60 不超过60
 */
@property (nonatomic, assign, readonly) int FPS;

/**
 视频质量因子
 默认值：23
 */
@property (nonatomic, assign, readonly) int CRF;

/**
 编码类型
 */
@property (nonatomic, assign, readonly) AliyunVideoCodecType videoCodec;

/**
 音频声道数
 */
@property(nonatomic, assign, readonly) AliyunAudioChannelType audioChannel;

/**
 音频采样率
 */
@property(nonatomic, assign, readonly) AliyunAudioSampleRate audioSampleRate;

/**
 缩放比
 默认值：1.0
 */
@property (nonatomic, assign, readonly) float scale;

/**
 输出分辨率
 */
@property (nonatomic, assign, readonly) CGSize outputResolution;

/**
 是否静音
 */
@property (nonatomic, assign, readonly) BOOL mute;

/**
 音量
 */
@property (nonatomic, assign, readonly) int volume;

/**
 背景颜色
 */
@property (nonatomic, strong, readonly) UIColor *backgroundColor;

/**
 裁剪模式

 - AliyunScaleModeFit: 裁剪
 - AliyunScaleModeFill: 填充
 */
@property (nonatomic, assign, readonly) AliyunScaleMode displayMode;

// MARK:
/**
 视频输出宽度
 */
@property (nonatomic, assign, readonly) int outputWidth __deprecated_msg("please use outputResolution");

/**
 视频输出高度
 */
@property (nonatomic, assign, readonly) int outputHeight __deprecated_msg("please use outputResolution");

@end
