//
//  ATResourceModel.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/11/18.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunResourceModel.h"

/**
 资源节点模块
 API_AVAILABLE(3.27.0)
 */
typedef NS_ENUM(NSUInteger, ATResourceModule) {
    ATResourceModule_Unkown,
    /**
     封面
     */
    ATResourceModule_Cover,
    
    /**
     主视频轨道
     */
    ATResourceModule_PreviewVideo,
    
    /**
     画中画轨道
     */
    ATResourceModule_Project,
};

/**
 资源数据模型
 API_AVAILABLE(3.27.0)
 */
@interface ATResourceModel : AliyunResourceModel

- (instancetype)initWithSource:(AEPSource *)source withModule:(ATResourceModule)module;

/**
 资源节点所在的模块
 */
@property (nonatomic, assign, readonly) ATResourceModule module;

@end
