//
//  AliyunAETemplateEditor.h
//  AlivcUgsvDemo
//
//  Created by Bingo on 2022/9/22.
//

#import <UIKit/UIKit.h>
#import "AliyunAETemplateAsset.h"
#import "AliyunAETemplate.h"

NS_ASSUME_NONNULL_BEGIN

/**
 Manager
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplateManager : NSObject

/**
 查询是否支持模板功能，armv7架构机型和模拟器不支持

 @return 支持或否
 */
+ (BOOL)canSupport;

@end

/**
 播放回调
 API_AVAILABLE(3.35.0)
 */
@protocol AliyunAETemplatePlayerDelegate <NSObject>

/**
 已完成加载
 */
- (void)playerDidLoaded;

/**
 播放结束
 */
- (void)playerDidEnd;

/**
 播放进度

 @param progress 进度，[0,1]
 */
- (void)playProgress:(double)progress;

/**
 播放出错

 @param errorCode 错误码
 */
- (void)playError:(NSInteger)errorCode;

@end


/**
 模板播放器
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplatePlayer : NSObject

/**
 delegate
 */
@property (nonatomic, weak) id<AliyunAETemplatePlayerDelegate> delegate;

/**
 播放

 @return 成功或否
 */
- (BOOL)start;

/**
 暂停

 @return 成功或否
 */
- (BOOL)pause;

/**
 停止播放

 @return 成功或否
 */
- (BOOL)stop;

/**
 seek

 @param second 时间点，单位秒
 @return 成功或否
 */
- (BOOL)seek:(NSTimeInterval)second;

/**
 获取时长

 @return 时长，单位秒
 */
- (NSTimeInterval)duration;

/**
 获取当前播放位置

 @return 当前播放位置，单位秒
 */
- (NSTimeInterval)currentTime;

/**
 获取播放视图

 @return 播放视图
 */
- (UIView *)getPlayerView;

@end

/**
 渲染回调
 API_AVAILABLE(3.35.0)
 */
@protocol AliyunAETemplateRenderDelegate <NSObject>

/**
 开始
 */
-(void)templateRenderStarted;

/**
 完成
 
 @param outputUrl
 */
-(void)templateRenderFinished:(NSURL *)outputUrl;

/**
 取消
 */
-(void)templateRenderCancelled;

/**
 失败

 @param error 错误信息
 */
-(void)templateRenderFailed:(NSError *)error;

/**
 进度

 @param progress 进度
 */
-(void)templateRenderProgress:(CGFloat)progress;

@end

/**
 模板渲染器
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplateRender : NSObject

/**
 delegate
 */
@property (nonatomic, weak) id<AliyunAETemplateRenderDelegate> delegate;

/**
 outputPath
 */
@property (nonatomic, copy) NSString *outputPath;

/**
 获取和设置当前编码器的比特率系数，默认值为0.25
 编码器的比特率计算公式为 width * height * framerate * bpp
 */
@property (nonatomic, assign) float bpp;


/**
 开始

 @return 成功或否
 */
-(BOOL)start;

/**
 取消
 */
-(void)cancel;

@end

/**
 模板编辑器
 API_AVAILABLE(3.35.0)
 */
@interface AliyunAETemplateEditor : NSObject

/**
 初始化编辑器

 @param templatePath 模板素材文件夹路径
 @return AliyunAETemplateEditor
 */
- (instancetype)initWithTemplatePath:(NSString *)templatePath;

/**
 当前模板
 */
@property (nonatomic, strong, readonly) AliyunAETemplate *currentTemplate;

/**
 播放器
 */
@property (nonatomic, strong, readonly) AliyunAETemplatePlayer *player;

/**
 渲染器
 */
@property (nonatomic, strong, readonly) AliyunAETemplateRender *render;

/**
 提交，素材执行替换后，需要调用该api才能生效
 */
- (void)commit;

/**
 替换背景音乐
 
 @param audioPath 音频文件路径，为nil时使用模板音乐，为空字符串时使用不使用音乐，
 */
- (void)replaceAudio:(NSString *)audioPath;


/**
 设置字体文件夹路径，会记录该文件夹下所有字体路径
 模板文件中使用字体会在该文件中查找，若没有找到，会使用默认字体
 调用不会覆盖之前的路径，会累计记录，同一字体名称会以后设置的路径为主
 @param fontFolder 字体文件夹路径
*/
+ (void)setFontFolder:(NSString *)fontFolder;

@end

NS_ASSUME_NONNULL_END
