//
//  AliyunMicRecordSource.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/4/22.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunAudioRecordController.h"
#import "AliyunEffect.h"

/**
 机器声音采集类型 API_AVAILABLE(3.22.0)
 */
typedef NS_ENUM(NSInteger, AliyunAudioUnitType) {
    /**
     参考kAudioUnitSubType_VoiceProcessingIO API_AVAILABLE(3.22.0)
     */
    AliyunAudioUnitType_RemoteIO,
    /**
     参考kAudioUnitSubType_RemoteIO API_AVAILABLE(3.22.0)
     */
    AliyunAudioUnitType_VoiceProcessingIO,
};

/**
 麦克风/机器声音源 API_AVAILABLE(3.22.0)
 */
@interface AliyunMicRecordSource : NSObject<AliyunRecordDataSource>
@property (nonatomic, readonly) AliyunAudioUnitType unitType;
- (instancetype) initWithUnitType:(AliyunAudioUnitType)unitType;
@end

/**
 麦克风控制器 API_AVAILABLE(3.22.0)
 */
@protocol AliyunMicRecordController <AliyunAudioRecordController>
/**
 API_AVAILABLE(3.27.0)
 降噪权值 [0~100]，取0表示关闭，值越大降噪越厉害
 */
@property (nonatomic, assign) int denoiseWeight;

/**
 麦克风源
 */
@property (nonatomic, readonly) AliyunMicRecordSource *micSource;

@end
