//
//  AliyunDraft.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/7/7.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPResourceModel.h"

@class UIImage;
/**
 本地草稿对象
 */
@interface AliyunDraft : NSObject
/**
 工程ID
 */
@property (nonatomic, copy, readonly) NSString *projectId;
/**
 草稿标题
 */
@property (nonatomic, copy, readonly) NSString *title;
/**
 创建时间
 */
@property (nonatomic, copy, readonly) NSString *createTime;
/**
 修改时间
 */
@property (nonatomic, copy, readonly) NSString *modifiedTime;
/**
 剪辑持续时间
 */
@property (nonatomic, assign, readonly) NSTimeInterval duration;
/**
 剪辑所有资源大小总和
 */
@property (nonatomic, assign, readonly) size_t size;
/**
 封面图路径
 */
@property (nonatomic, strong, readonly) AEPSource *cover;
/**
 如果来之剪同款，记录的模板来源
 */
@property (nonatomic, strong, readonly) AEPSource *templateSource;

/**
 修改工程ID
 
 @param projectId 工程ID
 */
- (void) changeProjectId:(NSString *)projectId;

/**
 重命名标题
 
 @param title 新的标题
 */
- (void) renameTitle:(NSString *)title;

/**
 更新封面图片，空表示自动获取编辑首帧画面
 */
- (void) updateCover:(UIImage *)coverImage;
@end

// MARK: - Load
/**
 加载任务
 */
@interface AliyunDraftLoadTask : NSObject
/**
 任务是否完成
 */
@property (nonatomic, assign, readonly) BOOL isFinish;
/**
 任务原始资源
 */
@property (nonatomic, strong, readonly) AEPResourceModel *resource;

/**
 加载成功
 
 @param result 加载结果
 */
- (void) onSuccess:(AEPSource *)result;
/**
 忽略这次加载任务
 */
- (void) onIgnore;
/**
 加载失败并删除对应的节点
 */
- (void) onFailToRemove;
/**
 加载这个任务失败并停止整个加载过程
 */
- (void) onFailToStopWithError:(NSError *)error;
@end

/**
 加载器
 
 @param tasks 加载的任务列表
 */
typedef void(^DraftTaskLoader)(NSArray<AliyunDraftLoadTask *> *tasks);

@class AliyunEditorBaseProject;
/**
 本地草稿加载完成回调
 
 @param taskPath 工程路径（如果加载失败则为空）
 @param project 工程对象（如果加载失败则为空）
 @param error 加载错误信息（如果加载成功则为空）
 */
typedef void(^LocalDraftLoadCallback)(NSString *taskPath, AliyunEditorBaseProject *project, NSError *error);

/**
 草稿加载扩展
 */
@interface AliyunDraft (Load)
/**
 加载草稿
 
 @param loader 加载器，需要调用方实现；实现草稿资源的加载
 @param completion 完成回到
 */
- (void) load:(DraftTaskLoader)loader completion:(LocalDraftLoadCallback)completion;
@end
