//
//  AEPTimeline.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPTrack.h"
#import "AEPStickerTrack.h"
#import "AEPEffectTrack.h"
#import "AEPGlobalTrack.h"

/**
 时间线
 */
@interface AEPTimeline : NSObject

/**
 持续时间，秒
 */
@property (nonatomic, assign, readonly) NSTimeInterval duration;

/**
 主视频轨道
 */
@property (nonatomic, readonly) AEPVideoTrack *mainVideoTrack;

/**
 画中画轨道
 */
@property (nonatomic, readonly) NSArray<AEPPipVideoTrack *> *pipVideoTracks;

/**
 音频轨道
 */
@property (nonatomic, copy, readonly) NSArray<AEPAudioTrack *> *audioTracks;

/**
 贴纸轨道
 */
@property (nonatomic, copy, readonly) NSArray<AEPStickerTrack *> *stickerTracks;

/**
 效果轨道
 */
@property (nonatomic, copy, readonly) NSArray<AEPEffectTrack *> *effectTracks;

/**
 涂鸦
 */
@property (nonatomic, strong, readonly) AEPGlobalPaintTrack *paintTrack;

/**
 水印
 */
@property (nonatomic, strong, readonly) AEPGlobalWatermarkTrack *watermark;

/**
 尾部水印
 */
@property (nonatomic, strong, readonly) AEPGlobalTailWatermarkTrack *tailWatermark;

/**
 主视频轨道
 */
@property (nonatomic, readonly) NSArray<AEPVideoTrack *> *videoTracks __deprecated_msg("please use mainVideoTrack");
@end
