//
//  AliyunDraft+Cloud.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/7/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AliyunDraft.h"
#import "AliyunDraftManager.h"

/**
 草稿工程文件上传任务
 */
@interface AliyunDraftProjectUploadTask : NSObject
/**
 任务是否完成
 */
@property (nonatomic, assign, readonly) BOOL isFinish;

/**
 草稿工程文件
 */
@property (nonatomic, copy, readonly) NSString *projectFilePath;

/**
 封面资源
 */
@property (nonatomic, strong, readonly) AEPSource *cover;

/**
 草稿对象
 */
@property (nonatomic, strong, readonly) AliyunDraft *draft;

/**
 上传成功
 */
- (void) onSuccess;

/**
 上传失败
 */
- (void) onFailWithError:(NSError *)error;
@end

@interface AliyunDraft (Cloud)
/**
 上传草稿
 
 @param resourceUploader 资源上传器
 @param projectUploader 工程上传器
 @param completion 上传完成回调
 */
- (void) uploadWithResourceUploader:(DraftTaskLoader)resourceUploader
                    projectUploader:(void(^)(AliyunDraftProjectUploadTask *projTask))projectUploader
                         completion:(void(^)(NSError *error))completion;
@end


@interface AliyunDraftManager (Cloud)
/**
 下载草稿
 
 @param projectFilePath 工程描述文件的文件路径
 @param downloader 资源下载器
 @param completion 下载完成的回调
 */
- (void) downloadDraftWithProjectFile:(NSString *)projectFilePath
                   resourceDownloader:(DraftTaskLoader)downloader
                           completion:(void(^)(AliyunDraft *draft, NSError *error))completion;
@end
