//
//  AliPrivateService.h
//  AliPrivateService
//
//  Created by shiping.csp on 2018/11/16.
//  Copyright © 2018 com.alibaba.AliyunPlayer. All rights reserved.
//

#import <Foundation/Foundation.h>

OBJC_EXPORT
@interface AliPrivateService : NSObject

/**
 @brief 初始化下载秘钥信息
 @param datFile 秘钥文件的路径
 */
+ (void)initKey:(NSString*)datFile;

/**
 @brief 初始化下载秘钥信息
 @param data 秘钥文件的内容
 */
+ (void)initKeyWithData:(NSData*)data;

/**
 @brief  初始化证书服务
 @param key 用户拥有的licenseKey信息
 @param licensePath 本地证书路径
 @param storageDir  下载证书文件夹路径
 */
+ (void)initLicenseService;


/**
 * AVPPremiumBizType 枚举类型：定义高级功能类型。
 * @discussion 此枚举包含了不同的业务类型，用于识别高级功能模块。
 */
typedef enum AVPPremiumBizType: NSUInteger {
    /**
     * 未知业务类型
     */
    BizType_UNKNOW = 0,
    
    /**
     * 媒体加载器功能
     */
    MediaLoader = 1,
    
    /**
     * 预渲染选项功能
     */
    PreRenderOption = 102,
    
    /**
     * 专业版自适应码率策略
     */
    PremiumAbrStrategy = 103,
    
    /**
     * H.265自适应功能
     */
    H265Adaptive = 104,
    
    /**
     * DASH协议支持
     */
    DashSupport = 105,
    
    /**
     * 扩展字幕功能
     */
    EXTSubtitle = 108,
    
    /**
     * H.266编解码支持
     * @deprecated 此校验已弃用
     * H266功能推荐使用插件方式实现，参考文档：<a href="https://help.aliyun.com/zh/vod/developer-reference/advanced-features-1#22ac7377ebae9">H.266解码插件</a>
     * @see AliPlayerGlobalSettings::enableCodecPlugin
     */
    H266Support = 109,
} AVPPremiumBizType;

/**
 * OnPremiumLicenseVerifyCallback 函数指针类型：高级功能验证回调。
 * @param type 高级功能类型
 * @param isValid 是否验证通过
 * @param errorMsg 错误信息（验证失败时返回）
 * @discussion 此回调用于验证指定的高级功能是否可用，并返回验证状态和错误信息。
 */
typedef void (*OnPremiumLicenseVerifyCallback)(AVPPremiumBizType type, bool isValid, NSString *errorMsg);


/**
 @brief  设置获取专业版License鉴权回调
 */
+ (void)setOnPremiumLicenseVerifyCallback:(OnPremiumLicenseVerifyCallback)callback;




@end

