//
//  QueenEngineConfigInfo.h
//  queen
//
//  Created by aliyun on 2021/3/14.
//  Copyright © 2021 alibaba-inc. All rights reserved.
//

#ifndef QueenEngineConfigInfo_H
#define QueenEngineConfigInfo_H

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/** 美颜类型，需要哪种美颜需要先打开
 */
typedef NS_ENUM(NSInteger, kQueenBeautyType) {
    /** 基础美颜（主要包括磨皮、锐化）
     */
    kQueenBeautyTypeSkinBuffing    =    0,
    /** 脸部美颜（主要包括去眼袋、法令纹、白牙、口红、腮红）
     */
    kQueenBeautyTypeFaceBuffing    =    1,
    /** 美妆（主要包括整妆、高光、美瞳、口红、眼妆）
     */
    kQueenBeautyTypeMakeup         =    2,
    /** 美型（主要包括瘦脸、瘦下巴、大眼、瘦鼻、美唇等）
     */
    kQueenBeautyTypeFaceShape      =    3,
    /** 基础美颜（美白）
     */
    kQueenBeautyTypeSkinWhiting    =    4,
    /** 滤镜，当设置滤镜后，可以指定一个滤镜图片
     */
    kQueenBeautyTypeLUT            =    5,
    /** 背景处理，实景抠图，使背景虚化
     */
    kQueenBeautyTypeBackgroundProcess = 6,
    /** 功能类型: 智能美颜
     */
    kQueenBeautyTypeAutoFilter     =    7,
    /** 功能类型: 美体
     */
    kQueenBeautyTypeBodyShape      =    8,
    /** 功能类型: 手势检测
     */
    kQueenBeautyTypeHandGestureDetect = 9,
    /** 功能类型: 脸部表情检测
     */
    kQueenBeautyTypeFaceExpressionDetect = 10,
    /** 功能类型: 换发色
     */
    kQueenBeautyTypeHairColor = 11,
    /**
     * 功能类型: 智能美型
     */
    kQueenBeautyTypeAutoFaceShape = 12,
    /** 功能类型: 人脸检测
     */
    kQueenBeautyTypeFaceDetect = 13,
    /** 功能类型: 人体检测
     */
    kQueenBeautyTypeBodyDetect = 14,
    /** 功能类型: 色相饱和度明度
     */
    kQueenBeautyTypeHSV = 15,
    /** 功能类型: 人脸打马赛克
     */
    kQueenBeautyTypeFaceMosaicing = 16,
    /**
     * 功能类型：隔空写字特效
     */
    kQueenBeautyTypeARWriting = 17,
    /** 功能类型: 专注度检测
     */
    kQueenBeautyTypedConcentrationDetect = 18,
    /** 功能类型: 异常行为(物体)检测
     */
    kQueenBeautyTypedAbnormalActionDetect = 19,
    /** 功能类型: 活体检测
     */
    kQueenBeautyTypedLivingHumanDetect = 20,
    /** 最大值
     */
    kQueenBeautyTypeMax = 21
};

/** 对应美颜类型的模式
 */
typedef NS_ENUM(NSInteger, kQueenBeautyFilterMode) {
    /** 默认值
     */
    kQueenBeautyFilterModeDefault = 0,
    /** 磨皮-自然
     */
    kQueenBeautyFilterModeSkinBuffing_Natural = 1,
    /** 磨皮-明显
     */
    kQueenBeautyFilterModeSkinBuffing_Strong = 2,
    /** 美型-基准线
     */
    kQueenBeautyFilterModeFaceShape_Baseline = 11,
    /** 美型-主流
     */
    kQueenBeautyFilterModeFaceShape_Main = 12,
    /** 美型-偏大变化
     */
    kQueenBeautyFilterModeFaceShape_High = 13,
    /** 美型-夸张
     */
    kQueenBeautyFilterModeFaceShape_Max = 14,
    /** 美妆-基准线
     */
    kQueenBeautyFilterModeFaceMakeup_Baseline = 21,
    /** 美妆-强烈
     */
    kQueenBeautyFilterModeFaceMakeup_High = 22,
    /**
    * 功能类型: AR隔空写字-写字模式
    */
    kQueenBeautyFilterModeArWriting_Writer = 31,
    /**
     * 功能类型: AR隔空写字-绘画模式
     */
    kQueenBeautyFilterModeArWriting_Drawer = 32

};


/**美颜参数，值为float
 */
typedef NS_ENUM(NSInteger, kQueenBeautyParams) {
    /** 基础美颜参数项，需要先打开kQueenBeautyTypeSkinBuffing 项
     磨皮，值的范围[0,1] ，默认0
     */
    kQueenBeautyParamsSkinBuffing      = 1,
    /** 基础美颜参数项，需要先打开kQueenBeautyTypeSkinBuffing 项
     锐化，值的范围[0,1] ，默认0
     */
    kQueenBeautyParamsSharpen          = 2,
    /** 基础美颜参数项，需要先打开kQueenBeautyTypeSkinBuffing 项
     美白，值的范围[0,1] ，默认0
     */
    kQueenBeautyParamsWhitening        = 3,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     去眼袋，值的范围[0,1]，默认0
     */
    kQueenBeautyParamsPouch            = 4,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     去法令纹，值的范围[0,1]，默认0
     */
    kQueenBeautyParamsNasolabialFolds  = 5,
    /** 色卡滤镜参数项，需要先打开QueenBeautyTypeLUT 项
     色卡滤镜强度，值的范围[0,1]，默认0
     */
    kQueenBeautyParamsLUT              = 6,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     白牙，值的范围[0,1]，默认0
     */
    kQueenBeautyParamsWhiteTeeth       = 7,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     口红，值的范围[0,1]，默认0
     */
    kQueenBeautyParamsLipstick         = 8,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     腮红，值的范围[0,1]，默认0
     */
    kQueenBeautyParamsBlush            = 9,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     口红色相 [-0.5,0.5], 默认0
    */
    kQueenBeautyParamsLipstickColorParam  = 10,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     口红饱和度[0,1], 默认0
    */
    kQueenBeautyParamsLipstickGlossParam  = 11,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     口红明度[0,1], 默认0
    */
    kQueenBeautyParamsLipstickBrightnessParam = 12,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     亮眼[0,1], 默认0
    */
    kQueenBeautyParamsBrightenEye         = 13,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     红润[0,1], 默认0
    */
    kQueenBeautyParamsSkinRed             = 14,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     祛皱纹[0,1], 默认0
    */
    kQueenBeautyParamsWrinkles             = 15,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     祛暗沉[0,1], 默认0
    */
    kQueenBeautyParamsBrightenFace         = 16,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     祛脖颈纹[0,1], 默认0
    */
    kQueenBeautyParamsNeck       = 20,
    /** 脸部美颜参数项，需要先打开QueenBeautyTypeFaceBuffing 项
     祛额头纹[0,1], 默认0
    */
    kQueenBeautyParamsForehead      = 21,
    /** 需要先打开QueenBeautyTypeHSV 项
     饱和度[-1,1], 默认0
     */
    kQueenBeautyParamsHSVSaturation      = 22,
    /** 需要先打开QueenBeautyTypeHSV 项
     对比度[-1,1], 默认0
     */
    kQueenBeautyParamsHSVContrast      = 23,
    /** 需要先打开QueenBeautyTypeFaceMosaicing 项
     人脸马赛克[0,1], 默认0
     */
    kQueenBeautyParamsFaceMosaicing      = 24

};

/**美妆类型，需要先打开QueenBeautyTypeMakeup 类型
 */
typedef NS_ENUM(NSInteger, kQueenBeautyMakeupType) {
    /** 整妆
     */
    kQueenBeautyMakeupTypeWhole       = 0,
    /** 高光
     */
    kQueenBeautyMakeupTypeHighlight   = 1,
    /** 美瞳
     */
    kQueenBeautyMakeupTypeEyeball     = 2,
    /** 口红
     */
    kQueenBeautyMakeupTypeMouth       = 3,
    /** 卧蚕
     */
    kQueenBeautyMakeupTypeWocan       = 4,
    /** 眉毛
     */
    kQueenBeautyMakeupTypeEyeBrow     = 5,
    /** 腮红
     */
    kQueenBeautyMakeupTypeBlush       = 6,
    /** 眼影
     */
    kQueenBeautyMakeupTypeEyeShadow   = 7,
    /** 眼线
     */
    kQueenBeautyMakeupTypeEyeliner    = 8,
    /** 睫毛
     */
    kQueenBeautyMakeupTypeEyelash     = 9,
    /** 最大值
     */
    kQueenBeautyMakeupTypeMakeupMax   = 10
};

/**美型类型，需要先打开kQueenBeautyTypeFaceShape 类型
 */
typedef NS_ENUM(NSInteger, kQueenBeautyFaceShapeType) {
    /** 颧骨，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeCutCheek      = 0,
    /** 削脸，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeCutFace       = 1,
    /** 瘦脸，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeThinFace      = 2,
    /** 脸长，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeLongFace      = 3,
    /** 下巴缩短，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeLowerJaw      = 4,
    /** 下巴拉长，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeHigherJaw     = 5,
    /** 瘦下巴，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeThinJaw       = 6,
    /** 瘦下颌，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeThinMandible  = 7,
    /** 大眼，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeBigEye        = 8,
    /** 眼角1，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeEyeAngle1     = 9,
    /** 眼距，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeCanthus       = 10,
    /** 拉宽眼距，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeCanthus1      = 11,
    /** 眼角2，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeEyeAngle2     = 12,
    /** 眼睛高度，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeEyeTDAngle    = 13,
    /** 瘦鼻，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeThinNose      = 14,
    /** 鼻翼，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeNosewing      = 15,
    /** 鼻长，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeNasalHeight   = 16,
    /** 鼻头长，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeNoseTipHeight = 17,
    /** 唇宽，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeMouthWidth    = 18,
    /** 嘴唇大小，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeMouthSize     = 19,
    /** 唇高，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeMouthHigh     = 20,
    /** 人中，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypePhiltrum      = 21,
    /** 发际线，值的范围[-1,1]，默认0
     */
    kQueenBeautyFaceShapeTypeHairLine = 22,
    /** 嘴角上扬(微笑)，值的范围[0,1]，默认0
     */
    kQueenBeautyFaceShapeTypeSmile = 23,
    /** 最大值
     */
    kQueenBeautyFaceShapeTypeMAX        = 24
};

/**美体类型，需要先打开kQueenBeautyTypeBodyShape 类型
 */
typedef NS_ENUM(NSInteger, kQueenBeautyBodyShapeType) {
    /** 全身，值的范围[-1,1]，默认0
     */
    kQueenBeautyBodyShapeTypeFullBody = 0,
    /** 长腿，值的范围[-1,1]，默认0
     */
    kQueenBeautyBodyShapeTypeLongLag,
    /** 小头，值的范围[-1,1]，默认0
     */
    kQueenBeautyBodyShapeTypeSmallHead,
    /** 瘦腿，值的范围[-1,1]，默认0
     */
    kQueenBeautyBodyShapeTypeThinLag,
    /** 脖子，值的范围[-1,1]，默认0
     */
    kQueenBeautyBodyShapeTypeLongNeck,
    /** 瘦腰，值的范围[-1,1]，默认0
     */
    kQueenBeautyBodyShapeTypeThinWaist,
    /** 丰胸，值的范围[-1,1]，默认0
     */
    kQueenBeautyBodyShapeTypeEnhanceBreast,
    /** 手臂，值的范围[-1,1]，默认0
     */
    kQueenBeautyBodyShapeTypeThinArm,
    /** 最大值
     */
    kQueenBeautyBodyShapeTypeMAX
};

/** 美妆混合模式
 */
typedef NS_ENUM(NSInteger, kQueenBeautyBlend) {
    /** 正常
     */
    kQueenBeautyBlendNormal = 0,
    /** 变亮
     */
    kQueenBeautyBlendLighten = 1,
    /** 变暗
     */
    kQueenBeautyBlendDarken = 2,
    /** 正片叠底
     */
    kQueenBeautyBlendMultiply = 3,
    /** 划分
     */
    kQueenBeautyBlendDivide = 4,
    /** 平均
     */
    kQueenBeautyBlendAverage = 5,
    /** 线性减淡
     */
    kQueenBeautyBlendAdd = 6,
    /** 减去
     */
    kQueenBeautyBlendSubtract = 7,
    /** 差值
     */
    kQueenBeautyBlendDifference = 8,
    /** 反向
     */
    kQueenBeautyBlendNegation = 9,
    /** 排除
     */
    kQueenBeautyBlendExclusion = 10,
    /** 滤色
     */
    kQueenBeautyBlendScreen = 11,
    /** 叠加
     */
    kQueenBeautyBlendOverlay = 12,
    /** 柔光
     */
    kQueenBeautyBlendSoftLight = 13,
    /** 强光
     */
    kQueenBeautyBlendHardLight = 14,
    /** 颜色减淡
     */
    kQueenBeautyBlendColorDodge = 15,
    /** 颜色加深
     */
    kQueenBeautyBlendColorBurn = 16,
    /** 线性减淡
     */
    kQueenBeautyBlendLinearDodge = 17,
    /** 线性加深
     */
    kQueenBeautyBlendLinearBurn = 18,
    /** 线性光
     */
    kQueenBeautyBlendLinearLight = 19,
    /** 亮光
     */
    kQueenBeautyBlendVividLight = 20,
    /** 点光
     */
    kQueenBeautyBlendPinLight = 21,
    /** 实色混合
     */
    kQueenBeautyBlendHardMix = 22,
    /** 反射
     */
    kQueenBeautyBlendReflect = 23,
    /** 发光
     */
    kQueenBeautyBlendGlow = 24,
    /** 颗粒
     */
    kQueenBeautyBlendPhoenix = 25,
    /** 色相
     */
    kQueenBeautyBlendHue = 26,
    /** 饱和度
     */
    kQueenBeautyBlendSaturation = 27,
    /** 明度
     */
    kQueenBeautyBlendLuminosity = 28,
    /** 颜色
     */
    kQueenBeautyBlendColor = 29,
    /** 曲线
     */
    kQueenBeautyBlendCurve = 30,
    /**
     * 视觉融合模式
     */
    kQueenBeautyBlendLabMix = 31,
    /** 最大值
     */
    kQueenBeautyBlendMax
};

/** 翻转类型
 */
typedef NS_ENUM(NSInteger, kQueenBeautyFlipAxis) {
    /** 不做翻转
     */
    kQueenBeautyFlipAxisNone       = 0,
    /** X轴翻转
     */
    kQueenBeautyFlipAxisX   = 1,
    /** Y轴翻转
     */
    kQueenBeautyFlipAxisY     = 2,
};

/** 状态码
 */
typedef NS_ENUM(NSInteger, kQueenResultCode) {
    /** QueenEngine内部错误
     */
    kQueenResultCodeUnKnown   = -1,
    /** 正常
     */
    kQueenResultCodeOK       = 0,
    /** license校验失败
     */
    kQueenResultCodeInvalidLicense   = 1,
    /** 参数错误
     */
    kQueenResultCodeInvalidParam   = 2,
    /** 没有应用任何Queen的特效处理
     */
    kQueenResultCodeNoEffect   = 3,
    /** 引擎没有配置信息
     */
    kQueenResultCodeNoConfigInfo   = 4
};

/** 颜色格式
 */
typedef NS_ENUM(NSInteger, kQueenImageFormat) {
    /** RGB
     */
    kQueenImageFormatRGB = 0,
    /** NV21
     */
    kQueenImageFormatNV21 = 1,
    /** NV12
     */
    kQueenImageFormatNV12 = 2,
    /** RGBA
     */
    kQueenImageFormatRGBA = 3
};

/** 手势识别的类别
 */
typedef NS_ENUM(NSInteger, kQueenStaticGestureType) {
    /** 没有识别到
     */
    kQueenStaticGestureTypeNone = -1,
    /** 其他手势
     */
    kQueenStaticGestureTypeOther,
    /** 数字1 / 申食指
     */
    kQueenStaticGestureTypeNumber1,
    /** 数字2 / yeah / 剪刀手
     */
    kQueenStaticGestureTypeNumber2,
    /** 数字3
     */
    kQueenStaticGestureTypeNumber3,
    /** 数字4
     */
    kQueenStaticGestureTypeNumber4,
    /** 数字5
     */
    kQueenStaticGestureTypeNumber5,
    /** 数字6 / 电话
     */
    kQueenStaticGestureTypeNumber6,
    /** 数字7
     */
    kQueenStaticGestureTypeNumber7,
    /** 数字8 / 单指手枪
     */
    kQueenStaticGestureTypeNumber8,
    /** 数字9
     */
    kQueenStaticGestureTypeNumber9,
    /** 拳头
     */
    kQueenStaticGestureTypeFist,
    /** OK
     */
    kQueenStaticGestureTypeOK,
    /** 单手比心
     */
    kQueenStaticGestureTypeHeart,
    /** 伸大拇指
     */
    kQueenStaticGestureTypeThumbUp,
    /** 申小指和无名指
     */
    kQueenStaticGestureTypeRingPinky,
    /** 申小指
     */
    kQueenStaticGestureTypePinky,
    /** 双指手枪
     */
    kQueenStaticGestureTypeGun,
    /** 摇滚 / 我爱你
     */
    kQueenStaticGestureTypeILoveyRock,
    /** 爪子
     */
    kQueenStaticGestureTypePaw,
    /** 中指
     */
    kQueenStaticGestureTypeMidFinger,
    /** VULCAN SALUTE 星际迷航手势
     */
    kQueenStaticGestureTypeVulcanSalute,
    /** 掐中指
     */
    kQueenStaticGestureTypeMidTip,
    /** 掐无名指
     */
    kQueenStaticGestureTypeRingTip,
    /** 杯子
     */
    kQueenStaticGestureTypeCup,
    /** 蛇
     */
    kQueenStaticGestureTypeSnake,
    /** 手指并拢
     */
    kQueenStaticGestureTypeFingersTogether,
    /** 手势识别类型数量
     */
    kQueenStaticGestureTypeMax,
};

/** 手部动作识别的类别
 */
typedef NS_ENUM(NSInteger, kQueenHandActionType) {
    /** 未知类型
     */
    kQueenHandActionTypeUnKnown = -2,
    /** 没有识别到
     */
    kQueenHandActionTypeNone = -1,
    /** 拇指指左
     */
    kQueenHandActionTypeLeft,
    /** 拇指指右
     */
    kQueenHandActionTypeRight,
    /** 拜拜
     */
    kQueenHandActionTypeGoodbye,
    /** 左滑
     */
    kQueenHandActionTypeSwipLeft,
    /** 右滑
     */
    kQueenHandActionTypeSwipRight,
    /** 上滑
     */
    kQueenHandActionTypeSwipUp,
    /** 下滑
     */
    kQueenHandActionTypeSwipDown,
    /** 伸出大拇指
     */
    kQueenHandActionTypeThumbUpDynamic,
    /** 放大
     */
    kQueenHandActionTypeZoomIn,
    /** 缩小
     */
    kQueenHandActionTypeZoomOut,
    /** 手部动作识别类型数量
     */
    kQueenHandActionTypeMax,
};

/** 脸部表情识别的类别
 */
typedef NS_ENUM(NSInteger, kQueenFaceExpressionType) {
    /** 无表情
     */
    kQueenFaceExpressionTypeNone = 0,
    /** 眨眼
     */
    kQueenFaceExpressionTypeBlink,
    /** 摇头
     */
    kQueenFaceExpressionTypeShakingHead,
    /** 挑眉
     */
    kQueenFaceExpressionTypeEyebrowRaise,
    /** 张嘴
     */
    kQueenFaceExpressionTypeOpenMouth,
    /** 说话
     */
    kQueenFaceExpressionTypeSaying,
    /** 脸部表情识别的数量
     */
    kQueenFaceExpressionTypeMax,
};

/** 实景抠像背景处理方式
 */
typedef NS_ENUM(NSInteger, kQueenBackgroundProcessType) {
    /** 背景虚化
     */
    kQueenBackgroundBlur        = 0,
    /** 背景透明
     */
    kQueenBackgroundTransparent = 1,
    /** 背景正常替换
     */
    kQueenBackgroundNormal = 2,

};

/** 实景抠像性能模式
 */
typedef NS_ENUM(NSInteger, kQueenSegmentPerformanceMode) {
    /** 自动模式（默认）
    */
    kQueenSegmentPMAuto        = 0,
    /** 最佳画质模式
    */
    kQueenSegmentPMQuality     = 1,
    /** 平衡模式
    */
    kQueenSegmentPMBalanced    = 2,
    /** 最佳性能模式
    */
    kQueenSegmentPMPerformance = 3,
};

/** 颜色类型
 */
typedef NS_ENUM(NSInteger, kQueenBeautyBgColorType) {
    /** 绿色
     */
    kQueenBeautyBgColorTypeGreen = 0,
    /** 蓝色
     */
    kQueenBeautyBgColorTypeBlue = 1,
    /** 青色
     */
    kQueenBeautyBgColorTypeCyan = 2,
    /** 紫色
     */
    kQueenBeautyBgColorTypePurple = 3,
    /** 黄色
     */
    kQueenBeautyBgColorTypeYellow = 4,
    /** 红色
     */
    kQueenBeautyBgColorTypeRed = 5,
};

/** 智能美型状态类型
 */
typedef NS_ENUM(NSInteger, kQueenAutoFaceShapeStatus) {
    /** 已激活
     */
    kQueenAutoFSActivated = 0,
    /** 检测中
     */
    kQueenAutoFSCapturing = 1,
    /** 检测完成
     */
    kQueenAutoFSCaptured = 2,
    /** 关闭
     */
    kQueenAutoFSDeActivated = 3
};

/** 算法参数输入模式
 */
typedef NS_ENUM(NSInteger, kQueenAlgInputMode) {
    /** 算法参数输入模式: 半自动。仅需要输入旋转角度
     */
    kQueenAlgInputModeSemiAutomatic = 0,
    /** 算法参数输入模式: 全自动。无需提供其他角度参数
     */
    kQueenAlgInputModeAutomatic = 1,
    /** 算法参数输入模式: 手动。需提供输入旋转角度、输出旋转角度、翻转参数等
     */
    kQueenAlgInputModeManual = 2
};

typedef struct{
    /** 俯仰角, 围绕X轴旋转
     */
    float yaw;
    /** 偏航角, 围绕Y轴旋转
     */
    float pitch;
    /** 翻滚角, 围绕Z轴旋转
     */
    float roll;
}QEYawPitchRoll;

/** 授权版本
 */
typedef NS_ENUM(NSInteger, kQueenLicenseVer) {
    /** 默认版本
     */
    kQueenLicenseVerDefault        = 0,
    /** 版本1
     */
    kQueenLicenseVer1 = 1,
};

/** 专注度类型
 */
typedef NS_ENUM(NSInteger, kConcentrationType) {
    /** 眨眼
     */
    kConcentrationTypeBlink = 0,
    /** 张嘴
     */
    kConcentrationTypeOpenMouth = 1,
    /** 摇头
     */
    kConcentrationTypeShakingHead = 2,
    /** 头上下移动
     */
    kConcentrationTypeYPR_Head_UpDown = 3,
    /** 头左右移动
     */
    kConcentrationTypeYPR_Head_LeftRight = 4
};

/** 异常动作(物体)类型
 */
typedef NS_ENUM(NSInteger, kAbnormalActionType) {
    /** 设备在左侧
     */
    kAbnormalActionTypeScene_Video_Left = 0,
    /** 光线过暗
     */
    kAbnormalActionTypeScene_Light_Dark_Out = 1,
    /** 光线过亮
     */
    kAbnormalActionTypeScene_Light_Bright_Out = 2,
    /** 人物进入
     */
    kAbnormalActionTypeScene_Person_Enter = 3,
    /** 人物离开
     */
    kAbnormalActionTypeScene_Person_Exit = 4,
    /** 人物画面占比
     */
    kAbnormalActionTypeScene_Person_In_Rect_Ratio = 5,
    /** 发现帽子
     */
    kAbnormalActionTypeObjectDetect_Hat = 31,
    /** 发现手机
     */
    kAbnormalActionTypeObjectDetect_CellPhone = 32,
    /** 发现手表
     */
    kAbnormalActionTypeObjectDetect_Watch = 33,
    /** 发现头戴式耳机
     */
    kAbnormalActionTypeObjectDetect_Headphone = 34,
    /** 发现入耳式耳机
     */
    kAbnormalActionTypeObjectDetect_EarPhone = 35,
    /** 发现图片
     */
    kAbnormalActionTypeObjectDetect_Picture = 36,
    /** 发现显示器
     */
    kAbnormalActionTypeObjectDetect_Moniter = 37,
    /** 发现手镯
     */
    kAbnormalActionTypeObjectDetect_Bracelet = 38,
    /** 发现围巾
     */
    kAbnormalActionTypeObjectDetect_Scarf = 39,
    /** 低抬头
     */
    kAbnormalActionTypeAction_Head_UpDown = 100,
    /** 左右摆头
     */
    kAbnormalActionTypeAction_Head_LeftRight = 101,
    /** 摇头
     */
    kAbnormalActionTypeAction_Head_Shaking = 102,
    /** 起立
     */
    kAbnormalActionTypeAction_Pose_Standup = 103,
    /** 坐下
     */
    kAbnormalActionTypeAction_Pose_Sitting = 104,
    /** 举手
     */
    kAbnormalActionTypeAction_Pose_Handup = 105,
    /** 人声说话
     */
    kAbnormalActionTypeAction_Person_Speech = 106
};

/** 活体动作类型
 */
typedef NS_ENUM(NSInteger, kLivingHumanActionType) {
    /** 眯眼
     */
    kLivingHumanActionType_Blink = 0,
    /** 张嘴哈欠
     */
    kLivingHumanActionType_OpenMouth = 1,
    /** 摇头晃脑
     */
    kLivingHumanActionType_ShakingHead = 2,
    /** 低抬头
     */
    kLivingHumanActionType_YPR_Head_UpDown = 3
};

@interface QueenEngineConfigInfo :NSObject

/**
 * licenseKey 在申请 Queen 授权时获得。如果是老版本的客户，之前申请授权时没有收到 licenseKey 的，请联系商务获取。
 */
@property (nonatomic, copy) NSString *licenseKey;

/**
 * 内置证书文件路径
 */
@property (nonatomic, copy) NSString *licenseFile;

/**
 * 授权版本
 */
@property (nonatomic, assign) kQueenLicenseVer licenseVer;

/**
 * Queen使用到的资源根目录，保持不变请为nil
 */
@property (nonatomic, copy) NSString *resRootPath;

/**
 * 是否内部自动创建GLContext，如果要处理CVPixelBuffer数据，需要设置为YES，默认为YES。
 */
@property (nonatomic, assign) BOOL withContext;

/**
 * 需要内部自动创建上下文的前提下，需要在创建引擎的时候同步创建GLContext，则设置为YES，默认为NO
 */
@property (nonatomic, assign) BOOL createContextSync;

/**
 * 是否要渲染到屏幕，默认为NO
 */
@property (nonatomic, assign) BOOL toScreen;

/**
 * 是否自动计算图像的inputAngle和outputAngle，默认为NO，API_AVAILABLE(ios(8.0))
 */
@property (nonatomic, assign) BOOL autoSettingImgAngle;

/**
 * 算法参数输入模式
 */
@property (nonatomic, assign) kQueenAlgInputMode algInputMode;

/**
 * 是否运行在自定义线程，默认为YES
 */
@property (nonatomic, assign) BOOL runOnCustomThread;

/**
 * 是否允许数据统计，默认为YES
 */
@property (nonatomic, assign) BOOL enableStats;

/**
 * 是否允许 SDK 往 控制台 输出详细日志，建议只在 Debug 包开启，避免日志输出过多影响性能，默认为NO
 */
@property (nonatomic, assign) BOOL enableDebugLog;

/**
 * 是否允许 SDK 缓存日志到本地文件，默认为YES
 */
@property (nonatomic, assign) BOOL enableCacheLog;

/**
 * 是否允许人脸检测算法采用gpu推理模式，默认为YES
 */
@property (nonatomic, assign) BOOL enableFaceDetectGPUMode;


/**
 * 是否允许人脸检测算法采用图片处理模式，默认为NO
 */
@property (nonatomic, assign) BOOL runImageMode;

/**
 * SDK 缓存日志到本地的文件目录路径
 */
@property (nonatomic, copy) NSString *logDirPath;

/**
 * 是否允许 SDK 上报 SDK的崩溃日志，默认为YES
 */
@property (nonatomic, assign) BOOL enableCrashReport;

/**
 * 预留字段，选填
 */
@property (nonatomic, copy) NSString *extraInfo;

@end

NS_ASSUME_NONNULL_END

#endif
