//
//  AEPTrack.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPVideoTrackClip.h"
#import "AEPAudioTrackClip.h"

/**
 轨道
 */
@interface AEPTrack : NSObject

/**
 轨道ID
 */
@property (nonatomic, assign, readonly) int trackId;

@end


/**
 视频轨道
 */
@interface AEPBaseVideoTrack : AEPTrack

/**
 视频持续时间
 */
@property (nonatomic, assign, readonly) NSTimeInterval duration;

@end

/**
 主视频轨道
 */
@interface AEPVideoTrack : AEPBaseVideoTrack
/**
 视频片段列表
 */
@property (nonatomic, copy, readonly) NSArray<AEPVideoTrackClip *> *clipList;
@end

/**
 画中画轨道
 */
@interface AEPPipVideoTrack : AEPBaseVideoTrack
/**
 视频片段列表
 */
@property (nonatomic, copy, readonly) NSArray<AEPPipVideoTrackClip *> *clipList;
@end


/**
 音频轨道
 */
@interface AEPAudioTrack : AEPTrack

/**
 音频持续时间
 */
@property (nonatomic, assign, readonly) NSTimeInterval duration;

/**
 音频片段列表
 */
@property (nonatomic, copy, readonly) NSArray<AEPAudioTrackClip *> *clipList;

@end
