//
//  AliyunDraftManager.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/7/7.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunDraft.h"

@class AliyunDraftManager;
@protocol AliyunDraftManagerDelegate <NSObject>
/**
 草稿列表发生变化
 */
- (void) onAliyunDraftManager:(AliyunDraftManager *)mgr listDidChange:(NSArray<AliyunDraft *> *)list;
@end

/**
 本地草稿管理器
 */
@interface AliyunDraftManager : NSObject
/**
 唯一标识
 */
@property (nonatomic, copy, readonly) NSString *identifier;
/**
 草稿列表
 */
@property (nonatomic, copy, readonly) NSArray<AliyunDraft *> *draftList;

/**
 事件回调
 */
@property (nonatomic, weak) id<AliyunDraftManagerDelegate> delegate;

/**
 初始化器
 
 @param identifier 唯一标识
 */
- (instancetype) initWithId:(NSString *)identifier;

/**
 添加草稿
 
 @param draft 草稿
 */
- (void) addDraft:(AliyunDraft *)draft;

/**
 删除草稿
 
 @param draft 将要被删除的草稿
 */
- (AliyunDraft *) deleteDraft:(AliyunDraft *)draft;

/**
 复制草稿
 
 @param draft 将要被复制的草稿
 @param taskPath 新草稿的路径
 @param title 新草稿的标题
 */
- (AliyunDraft *) copyDraft:(AliyunDraft *)draft toPath:(NSString *)taskPath withTitle:(NSString *)title;
@end
