//
//  AliyunEditorProject.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/13.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPConfig.h"
#import "AEPTimeline.h"
#import "AEPSource.h"

/**
 基础编辑工程数据模型
 */
@interface AliyunEditorBaseProject : NSObject
/**
 当前SDK的工程版本号
 */
@property (nonatomic, class, readonly) int CurrentVersion;

/**
 工程文件的版本号
 */
@property (nonatomic, assign, readonly) int version;

/**
 工程ID，由用户确定，默认为空
 */
@property (nonatomic, copy, readonly) NSString *projectId;

/**
 标题
 */
@property (nonatomic, copy) NSString *title;

/**
 创建时间
 */
@property (nonatomic, copy, readonly) NSString *createTime;

/**
 修改时间
 */
@property (nonatomic, copy, readonly) NSString *modifiedTime;

/**
 工程状态（保留值，当前为空）
 */
@property (nonatomic, copy, readonly) NSString *status;

/**
 工程描述信息
 */
@property (nonatomic, copy) NSString *info;

/**
 持续时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval duration;

/**
 工程资源总大小(KB)
 */
@property (nonatomic, assign, readonly) size_t resourceSize;

/**
 工程配置
 */
@property (nonatomic, strong, readonly) AEPConfig *config;

/**
 封面资源
 */
@property (nonatomic, strong, readonly) AEPSource *cover;


/**
 如果来之剪同款，记录的模板来源
 */
@property (nonatomic, strong, readonly) AEPSource *templateSource;


@end

/**
 编辑工程数据模型
 */
@interface AliyunEditorProject : AliyunEditorBaseProject

/**
 时间线
 */
@property (nonatomic, strong, readonly) AEPTimeline *timeline;

@end
