//
//  AliyunPlayerRecordSource.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AliyunVideoRecordController.h"
#import "AliyunViewRecordSource.h"
#import "AliyunAudioRecordController.h"

/**
 视频播放器源 API_AVAILABLE(3.22.0)
 */
__deprecated_msg("please use AliyunFileRecordSource")
@interface AliyunPlayerRecordSource : NSObject<AliyunRecordDataSource, AliyunRecordSourceFPS>
/**
 内容适配策略 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, copy) AVLayerVideoGravity gravity;
/**
 视频的分辨率 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) CGSize resolution;
/**
 视频时长(秒） API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) NSTimeInterval duration; // second
/**
 采集速率 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) CGFloat rate;
/**
 目标视频 API_AVAILABLE(3.23.0)
 */
@property (nonatomic, readonly) AVAsset *targetAsset;

/**
  API_AVAILABLE(3.22.0)
 @param asset 视频资源
 @param fps 采集频率
 */
- (instancetype) initWithAsset:(AVAsset *)asset fps:(int)fps;
@end

/**
 视频播放的录制控制器 API_AVAILABLE(3.22.0)
 */
__deprecated_msg("please use AliyunAVFileRecordController")
@protocol AliyunPlayerRecordController<AliyunVideoBaseRecordController, AliyunAudioRecordController>
/**
  API_AVAILABLE(3.22.0)
 预览视图

 必须设置
 */
@property (nonatomic, weak) UIView *preview;

/**
 视频播放源 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) AliyunPlayerRecordSource *player;
@end
