//
//  AliyunRecordController.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/4/26.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AliyunRecordSource.h"

@protocol AliyunRecordController;
/**
 自定义数据源数据处理 API_AVAILABLE(3.22.0)
 */
@protocol AliyunRecordControllerCustomSourceHandler <NSObject>
@optional
/**
  API_AVAILABLE(3.22.0)
 数据流采集源返回的原始数据
 可用于做自定义的人脸识别
 */
- (void) onAliyunRecordController:(id<AliyunRecordController>)controller
               customHandleVideo:(CMSampleBufferRef)buffer
                withDisplayMatrix:(CATransform3D)transform;

/**
  API_AVAILABLE(3.22.0)
 数据流采集源返回的原始数据
 可用于做自定义的语音识别等
 */
- (void) onAliyunRecordController:(id<AliyunRecordController>)controller
          customHandleAudioBuffer:(CMSampleBufferRef)buffer;
@end

/**
 录制源的控制器 API_AVAILABLE(3.22.0)
 */
@protocol AliyunRecordController <NSObject>
/**
 录制源唯一标识 API_AVAILABLE(3.29.0)
 */
@property (nonatomic, readonly) NSUInteger sourceId;
/**
 标记录制源是否已经准备好 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) BOOL isReady;
/**
 录制源 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) id<AliyunRecordSource> source;
/**
 自定义数据处理回调 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, weak) id<AliyunRecordControllerCustomSourceHandler> customHandler;

/**
 是否正在采集 API_AVAILABLE(3.27.0)
 */
@property (nonatomic, readonly) BOOL isRunning;

/**
 是否需要渲染
 */
@property (nonatomic, assign) BOOL needRender;

/**
 是否需要保存
 */
@property (nonatomic, assign) BOOL needOutput;

/**
 开始采集 API_AVAILABLE(3.27.0)
 */
- (void) start;
/**
 停止采集 API_AVAILABLE(3.27.0)
 */
- (void) stop;
@end
