//
//  AEPVideoTrackClip.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunVideoParam.h"
#import "AEPSource.h"
#import "AEPAction.h"
#import "AEPEffect.h"
#import "AEPTransitionEffect.h"
#import "AliyunClip.h"

/**
 视频片段
 */
@interface AEPBaseVideoTrackClip : NSObject

/**
 片段类型
 */
@property (nonatomic, assign, readonly) AliyunClipType type;

/**
 视频ID
 */
@property (nonatomic, assign, readonly) int mediaId;

/**
 片段资源
 */
@property (nonatomic, strong, readonly) AEPSource *source;

/**
 片段内部开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval clipIn;

/**
 片段内部结束时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval clipOut;

/**
 片段时长
 */
@property (nonatomic, assign, readonly) NSTimeInterval clipDuration;

/**
 时间线上的开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineIn;

/**
 时间线上的结束时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineOut;

/**
 时间线的持续时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval duration;

/**
 视频分辨率
 */
@property (nonatomic, assign, readonly) CGSize clipResolution;

/**
 视频旋转角度
 */
@property (nonatomic, assign, readonly) int clipRotation;

/**
 亮度值
 */
@property (nonatomic, assign, readonly) float brightnessValue;

/**
 对比度值
 */
@property (nonatomic, assign, readonly) float contrastValue;

/**
 暗角值
 */
@property (nonatomic, assign, readonly) float vignetteValue;

/**
 饱和度值
 */
@property (nonatomic, assign, readonly) float saturationValue;

/**
 锐度值
 */
@property (nonatomic, assign, readonly) float sharpnessValue;

/**
 是否水平翻转
 */
@property(nonatomic, assign, readonly) BOOL horizontalFlip;


/**
 混音权重
 */
@property (nonatomic, assign, readonly) int mixWeight;

/**
 降噪权重
 */
@property (nonatomic, assign, readonly) int denoiseWeight;

/**
 音效
 */
@property (nonatomic, strong, readonly) AEPAudioEffect *audioEffect;
/**
 声音淡入效果
 */
@property (nonatomic, strong, readonly) AEPAudioFadeEffect *fadeInEffect;
/**
 声音淡出效果
 */
@property (nonatomic, strong, readonly) AEPAudioFadeEffect *fadeOutEffect;

/**
 动画列表
 */
@property (nonatomic, copy, readonly) NSArray<AEPAction *> *actions;

@end

/**
 主流片段
 */
@interface AEPVideoTrackClip : AEPBaseVideoTrackClip

/**
 编辑器中的片段对象
 */
@property (nonatomic, strong, readonly) AliyunClip *editorClip;

/**
 裁剪模式

 - AliyunScaleModeFit: 裁剪
 - AliyunScaleModeFill: 填充
 */
@property (nonatomic, assign, readonly) AliyunScaleMode displayMode;

/**
 转场效果
 和前一段视频/图片之间的转场效果
 */
@property (nonatomic, strong, readonly) AEPTransitionEffect *transitionEffect;

/**
 模糊背景效果
 */
@property (nonatomic, copy, readonly) NSArray<AEPBlurBackgroundEffect *> *blurBackgroundEffects;
@end

@class AEPClipBorderInfo;
@class AliyunPipClipController;
/**
 画中画片段
 */
@interface AEPPipVideoTrackClip : AEPBaseVideoTrackClip

/**
 编辑器中的片段对象
 */
@property (nonatomic, strong, readonly) AliyunPipClipController *editorClipController;

/**
 归一化中心点位置
 */
@property (nonatomic, assign, readonly) CGPoint normalizedCenter;

/**
 归一化大小
 */
@property (nonatomic, readonly) CGSize normalizedSize;

/**
 缩放值，默认为1.0
 */
@property (nonatomic, assign, readonly) CGFloat scale;

/**
 透明度，默认值为1.0
 */
@property (nonatomic, assign, readonly) CGFloat alpha;

/**
 视频输出旋转弧度
 */
@property (nonatomic, assign, readonly) CGFloat outputRotation;

/**
 片段边框信息
 */
@property (nonatomic, strong, readonly) AEPClipBorderInfo *borderInfo;
@end

/**
 片段的边框信息
 */
@interface AEPClipBorderInfo : NSObject

/**
 边框颜色
 */
@property (nonatomic, strong, readonly) UIColor *color;

/**
 边框宽度，归一化
 */
@property (nonatomic, assign, readonly) CGFloat normalizedWidth;

/**
 边框圆角半径，归一化
 */
@property (nonatomic, assign, readonly) CGFloat normalizedCornerRadius;
@end
