//
// Created by yiliang on 2023/4/12.
//

#ifndef SOURCE_ALIVRPLAYERDELEGATE_H
#define SOURCE_ALIVRPLAYERDELEGATE_H

/**
 * VR 播放器的代理协议。
 *
 * <p>该协议定义了 VR 播放器在交互过程中角度变化的回调方法。
 *
 * <p>所有方法均为可选实现（@optional）。
 */
@protocol AliVRPlayerDelegate <NSObject>

@optional

/**
 * 运动传感器角度发生变化时的回调。
 *
 * <p>当设备的运动传感器（如陀螺仪）检测到水平角度变化时调用此方法。
 *
 * @param sensorAngleX 传感器检测到的水平角度值
 */
- (void)motionSensorAngleChanged:(CGFloat)sensorAngleX;

/**
 * 手势控制角度发生变化时的回调。
 *
 * <p>当用户通过手势（如滑动）控制 VR 视角时，水平角度发生变化会调用此方法。
 *
 * @param gestureAngleX 手势控制的水平角度值
 */
- (void)gestureAngleChanged:(CGFloat)gestureAngleX;

@end

#endif //SOURCE_ALIVRPLAYERDELEGATE_H
