//
//  AliyunPartAction.h
//  AliyunVideoSDKPro
//
//  Created by mengyehao on 2021/9/14.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunAction.h"

/**
 子节点动画执行顺序 API_AVAILABLE(3.25.0)
 */
typedef NS_ENUM(NSInteger, AliyunActionPartParamMode) {
    
    AliyunActionPartParamModeSequence, //从左到右顺序执行
    AliyunActionPartParamModeReverse,  //从右到左逆序执行
    AliyunActionPartParamModeRandom,   //随机执行
    AliyunActionPartParamModeMiddle,   //从中间到两边
};


/**
 子节点动画参数
 */
@interface AliyunActionPartParam : NSObject<NSCopying>


/**
 子节点动画执行顺序 @see AliyunActionPartParamMode. API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign) AliyunActionPartParamMode partMode;


/**
 两个子节点之间的重叠部分，[0-1],1：全部重叠，0：不重叠. API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign) float partOverlayRadio;


@end

/**
 子节点动画
 */
@interface AliyunPartAction : NSObject

/**
 action包含的具体动画 @see AliyunAction. API_AVAILABLE(3.25.0)
 */
@property (nonatomic, strong, readonly) AliyunAction *action;

/**
 partParam 部分动画参数 @see AliyunActionPartParam. API_AVAILABLE(3.25.0)
 */
@property (nonatomic, strong) AliyunActionPartParam *partParam;


/**
 初始化 API_AVAILABLE(3.25.0)

 @param action 包含的具体动画
 @return AliyunPartAction
 */
- (instancetype)initWithAction:(AliyunAction *)action;
@end


