//
//  AEPSource.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 资源类型
 */
typedef NS_ENUM(NSUInteger, AEPSourceType) {
    AEPSourceType_Video,
    AEPSourceType_Image,
    AEPSourceType_Gif,
    AEPSourceType_Audio,
    AEPSourceType_MV,
    AEPSourceType_Font,
    AEPSourceType_Config,
};

/**
 编辑工程资源
 */
@interface AEPSource : NSObject

/**
 资源类型
 */
@property (nonatomic, assign, readonly) AEPSourceType type;

/**
 资源ID
 */
@property (nonatomic, copy, readonly) NSString *sourceId;

/**
 资源路径
 */
@property (nonatomic, copy, readonly) NSString *path;

/**
 资源远端地址
 */
@property (nonatomic, copy, readonly) NSString *URL;

/**
 资源大小(KB)
 */
@property (nonatomic, assign, readonly) size_t size;

/**
 是否本地资源
 */
@property (nonatomic, assign, readonly) BOOL isLocal;
@end

/**
 资源创建方法
 */
@interface AEPSource (Creator)
/**
 创建资源对象
 
 @param type 资源类型
 @param sourceId 资源ID，可选
 @param url 资源远端地址，可选
 @param path 资源本地地址，可选
 */
+ (AEPSource *) SourceWithType:(AEPSourceType)type
                      sourceId:(NSString *)sourceId
                           url:(NSString *)url
                          path:(NSString *)path;

/**
 通过修改本地路径创建资源对象
 
 @param path 本地路径
 */
- (AEPSource *) createWithPath:(NSString *)path;

/**
 通过修改远程路径创建资源对象
 
 @param url 远端地址
 */
- (AEPSource *) createWithURL:(NSString *)URL;

/**
 通过资源ID创建资源对象
 
 @param sourceId 资源ID
 */
- (AEPSource *) createWithSourceId:(NSString *)sourceId;
@end
