//
//  AEPStickerTrack.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPTrack.h"
#import "AliyunCaptionSticker.h"

/**
 贴纸轨道
 */
@interface AEPStickerTrack : AEPTrack
@end

@class AliyunRollCaptionItemStyle;
/**
 翻转字幕元素
 */
@interface AEPRollCaptionItem : NSObject
/**
 字幕
 */
@property (nonatomic, copy, readonly) NSString *text;
/**
 字体资源，其中sourceId表示字体名称
 */
@property (nonatomic, strong, readonly) AEPSource *font;
/**
 文字颜色
 */
@property (nonatomic, strong, readonly) UIColor *textColor;
/**
 字体描边颜色
 */
@property (nonatomic, strong, readonly) UIColor *outlineColor;
/**
 时间线上的开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineIn;

/**
 编辑器中使用的翻转字幕元素对象
 */
@property (nonatomic, strong, readonly) AliyunRollCaptionItemStyle *editorItem;
@end

/**
 翻转字幕
 */
@interface AEPRollCaptionTrack : AEPStickerTrack
/**
 翻转字幕组成元素列表
 */
@property (nonatomic, copy, readonly) NSArray<AEPRollCaptionItem *> *items;
/**
 编辑器中使用的翻转字幕元素列表
 */
/**
The list of roll caption item that using in editor
 */
@property (nonatomic, copy, readonly) NSArray<AliyunRollCaptionItemStyle *> *editorItems;
@end

/**
 贴子基础类
 */
@interface AEPStickerBaseTrack : AEPStickerTrack
/**
 贴纸ID
 */
@property (nonatomic, assign, readonly) int stickerId;

/**
 时间线上的开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineIn;

/**
 时间线上的结束时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineOut;
/**
 旋转角度
 */
@property (nonatomic, assign, readonly) float rotation;
/**
 镜像
 */
@property (nonatomic, assign, readonly) BOOL mirror;

/**
 归一化中心点位置
 */
@property (nonatomic, readonly) CGPoint normalizedCenter;
/**
 归一化大小
 */
@property (nonatomic, readonly) CGSize normalizedSize;

/**
 动画效果列表
 */
@property (nonatomic, copy, readonly) NSArray<AEPAction *> *actions;
@end

@class AliyunImageStickerController;
/**
 静态图片贴纸
 */
@interface AEPImageStickerTrack : AEPStickerBaseTrack
/**
 贴纸资源
 */
@property (nonatomic, strong, readonly) AEPSource *source;

/**
 编辑器中使用的静态贴纸控制器
 */
@property (nonatomic, strong, readonly) AliyunImageStickerController *imageStickerController;
@end

@class AliyunGifStickerController;
/**
 Gif贴纸
 */
@interface AEPGifStickerTrack : AEPStickerBaseTrack
/**
 贴纸资源
 */
@property (nonatomic, strong, readonly) AEPSource *source;
/**
 编辑器中使用的Gif贴纸控制器
 */
@property (nonatomic, strong, readonly) AliyunGifStickerController *gifStickerController;
@end

/**
 字幕基础类
 */
@interface AEPCaptionBaseTrack : AEPStickerBaseTrack
/**
 字幕文字
 */
@property (nonatomic, copy, readonly) NSString *text;
/**
 字体资源，sourceId表示字体名称
 */
@property (nonatomic, strong, readonly) AEPSource *font;
/**
 文字颜色
 */
@property (nonatomic, strong, readonly) UIColor *textColor;
/**
 文字背景颜色
 */
@property (nonatomic, strong, readonly) UIColor *textBgColor;
@end

@class AliyunCaptionStickerController;
/**
 字幕轨道
 */
@interface AEPCaptionTrack : AEPCaptionBaseTrack

/**
 逐字动画
 */
/**
 part animation
 */
@property (nonatomic, copy, readonly) NSArray<AEPPartAction *> *partActions;

/**
 气泡资源
 */
@property (nonatomic, strong, readonly) AEPSource *source;

/**
 描边颜色
 */
@property (nonatomic, strong, readonly) UIColor *outlineColor;

/**
 字体样式 @see AliyunCaptionStickerFaceType
 */
@property (nonatomic, assign, readonly) AliyunCaptionStickerFaceType faceType;

/**
 字幕缩放值，默认为1.0
 */
@property (nonatomic, assign, readonly) CGFloat scale;

/**
 圆角大小， 默认等于0  API_AVAILABLE(3.31.0)
 */
@property (nonatomic, assign, readonly) CGFloat cornerRadius;

/**
 描边宽度，单位：像素 默认0
 */
@property (nonatomic, assign, readonly) CGFloat outlineWidth;

/**
 阴影颜色，默认nil
 */
@property (nonatomic, strong, readonly) UIColor *shadowColor;

/**
 阴影的偏移值，默认 UIOffsetZero, x/y单位：像素，默认UIOffsetZero
 */
@property (nonatomic, assign, readonly) UIOffset shadowOffset;

/**
 花字效果文件夹路径
 */
@property (nonatomic, strong, readonly) AEPSource *fontEffectSource;

/**
 对齐方式
 */
@property (nonatomic, assign, readonly) AliyunCaptionStickerTextAlignment textAlignment;


/**
 编辑器中使用的字幕控制器
 */
@property (nonatomic, strong, readonly) AliyunCaptionStickerController *captionStickerController;
@end

/**
 废弃的字幕轨道基类
 */
@interface AEPDeprecatedCaptionTrack : AEPCaptionBaseTrack
/**
 是否有描边
 */
@property (nonatomic, assign, readonly) BOOL hasStroke;
/**
 描边颜色
 */
@property (nonatomic, strong, readonly) UIColor *strokeColor;
@end

@class AliyunEffectSubtitle;
/**
 废弃的纯文字
 */
@interface AEPSubtitleTrack : AEPDeprecatedCaptionTrack
/**
 编辑器中使用的纯文字对象
 */
@property (nonatomic, strong, readonly) AliyunEffectSubtitle *editorSubtitle;
@end

@class AliyunEffectCaption;
/**
 废弃的气泡字
 */
@interface AEPBubbleCaptionTrack : AEPDeprecatedCaptionTrack
/**
 气泡资源
 */
@property (nonatomic, strong, readonly) AEPSource *source;

/**
 归一化的文字大小
 */
@property (nonatomic, assign, readonly) CGSize normalizedTextSize;

/**
 归一化的文字位置（相对于气泡字本身）
 */
@property (nonatomic, assign, readonly) CGPoint normalizedTextCenter;
/**
 在编辑器中使用的气泡字对象
 */
@property (nonatomic, strong, readonly) AliyunEffectCaption *editorCaption;
@end
