//
//  AliyunVideoRecordCommonModel.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/12/22.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunRenderModel.h"

/**
 视频源布局参数 API_AVAILABLE(3.22.0)
 */
@interface AliyunVideoRecordLayoutParam : AliyunRenderModel<NSCopying>
/**
 视频层级 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) int zPosition;
/**
  API_AVAILABLE(3.22.0)
 初始化
 @param mode 渲染模式
 */
- (instancetype) initWithRenderMode:(AliyunRenderMode)mode;
/**
 设置自适应方式 API_AVAILABLE(3.22.0)
 */
- (void) setAutoresizingMask:(UIViewAutoresizing)mask;
@end

/**
 视频源的边框信息 API_AVAILABLE(3.22.0)
 */
@interface AliyunVideoRecordBorderInfo : NSObject<NSCopying>
/**
 边框的颜色 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, strong) UIColor *color;
/**
 边框的宽度，基于整体输出视频分辨率的像素值 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) CGFloat width;
/**
 边框的圆角半径，基于整体输出分辨率的像素值 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) CGFloat cornerRadius;
@end
