//
//  AliyunVideoRecordController.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/4/26.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AliyunRecordController.h"
#import "AliyunFacePoint.h"
#import "AliyunEffectFilter.h"
#import "AliyunImageStickerController.h"
#import "AliyunGifStickerController.h"
#import "AliyunVideoRecordCommonModel.h"
#import <UIKit/UIKit.h>

/**
 根据机器方向判断旋转的协议 API_AVAILABLE(3.22.0)
 */
@protocol AliyunVideoSourceOrientation <NSObject>
@optional
/**
 计算旋转到对应方向的角度 API_AVAILABLE(3.22.0)
 */
- (int) rotateToOrientation:(UIDeviceOrientation)orientation;
/**
  API_AVAILABLE(3.22.0)
 当前重力方向的旋转角度
 用于人脸识别
 */
- (int) rotateToGravity;
/**
 更新重力方向 API_AVAILABLE(3.22.0)
 */
- (void) updateGravityRotate:(UIDeviceOrientation)orientation;
@end

/**
 基础视频控制器 API_AVAILABLE(3.22.0)
 */
@protocol AliyunVideoBaseRecordController <AliyunRecordController>
/**
 边框信息 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, strong) AliyunVideoRecordBorderInfo *borderInfo;
/**
 布局参数 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) AliyunVideoRecordLayoutParam *layoutParam;
@end


/**
 全功能的视频控制器 API_AVAILABLE(3.22.0)
 */
@protocol AliyunVideoRecordController<AliyunVideoBaseRecordController>
/**
  API_AVAILABLE(3.22.0)
 预览视图

 必须设置
 */
@property (nonatomic, weak) UIView *preview;

/**
 预览视图渲染模式 API_AVAILABLE(6.9.1)
 */
@property(nonatomic, assign) AliyunRenderMode previewRenderMode;

/**
 预览视图分辨率 API_AVAILABLE(6.9.2)
 */
@property(nonatomic, assign) CGSize previewResolution;

/**
 录制的视频是否左右翻转（只影响输出，不影响预览） API_AVAILABLE(3.22.0)
 */
@property(nonatomic, assign) BOOL isVideoMirror;

/**
 录制的视频是否左右翻转（预览生效） API_AVAILABLE(6.9.1)
 */
@property(nonatomic, assign) BOOL isPreviewMirror;

/**
 美颜状态是否开启 API_AVAILABLE(3.22.0)
 */
@property(nonatomic, assign) BOOL beautifyStatus;

/**
 设置美颜度 [0,100] API_AVAILABLE(3.22.0)
 */
@property(nonatomic, assign) int beautifyValue;

/**
  API_AVAILABLE(3.22.0)
 是否开启人脸识别

 使用自带人脸识别，开启该功能，系统会在检测到有人脸动图加入时自动进行追踪显示
 */
@property(nonatomic, assign) BOOL useFaceDetect;

/**
  API_AVAILABLE(3.22.0)
 设置识别人脸的个数 当设置值小于1时，默认为1；当设置值大于3时，默认为3

 最大是3个 最小是1个  如果不需要检测人脸 使用:useFaceDetect = NO
 */
@property(nonatomic, assign) int faceDetectCount;

/**
  API_AVAILABLE(3.22.0)
 人脸数量的回调

 在useFaceDetect开启的状态下生效
 */
@property(nonatomic, copy) void (^faceNumbersCallback)(int num);

/**
  API_AVAILABLE(3.22.0)
 是否同步贴合人脸

 同步贴合人脸动图会在同步线程执行，优点是贴合性强，缺点是性能差的设备会有卡顿现象
 非同步贴合人脸动图，有点是画面流畅但贴图贴合性不强
 默认是YES，6及以下机型建议异步，6以上建议同步
 */
@property(nonatomic, assign) BOOL faceDectectSync;

/**
  API_AVAILABLE(3.22.0)
 人脸追踪 用户可以选择其他人脸识别库，但是传进来的数据须封装成AliyunFacePoint

 @param facePoints 人脸点数组
 */
- (void)faceTrack:(NSArray<AliyunFacePoint *> *)facePoints;

/**
  API_AVAILABLE(3.22.0)
 拍摄一张图片 异步获取

 image 采集的渲染后图片
 rawImage 采集的原始图片
 */
- (void)takePhoto:(void (^)(UIImage *rawImage, UIImage *image))handler;

/**
  API_AVAILABLE(3.22.0)
  添加人脸贴图
 
  @param configDirectory 人脸贴图配置文件夹路径
 */
- (int) applyFaceSticker:(NSString *)configDirectory;

/**
  API_AVAILABLE(3.22.0)
  删除人脸贴图
 */
- (void) deleteFaceSticker;

/**
  API_AVAILABLE(3.22.0)
 添加动图

 @param configDirectory 动图配置文件夹路径
 */
- (AliyunGifStickerController *) addGifStickerWithConfig:(NSString *)configDirectory;

/**
 添加图片 API_AVAILABLE(3.22.0)

 @param image 图片
 */
- (AliyunImageStickerController *) addImageSticker:(NSString *)imagePath;

/**
 删除贴纸 API_AVAILABLE(3.22.0)

 @param stickerId 贴纸id
 */
- (void)deleteSticker:(int)stickerId;

/**
 添加滤镜 API_AVAILABLE(3.22.0)

 @param filter 滤镜
 */
- (int)applyFilter:(AliyunEffectFilter *)filter;

/**
 删除滤镜 API_AVAILABLE(3.22.0)
 */
- (void)deleteFilter;

/**
 添加动效滤镜 API_AVAILABLE(3.22.0)

 @param filter 滤镜
 @return 返回值
 */
- (int)applyAnimationFilter:(AliyunEffectFilter *)filter;

/**
 更新动效滤镜 API_AVAILABLE(3.22.0)

 @param filter 滤镜
 @return 返回值
 */
- (int)updateAnimationFilter:(AliyunEffectFilter *)filter;

/**
 删除动效滤镜 API_AVAILABLE(3.22.0)
 */
- (void)deleteAnimationFilter;


@end
