//
// Created by Pi on 2025/04/15.
//

#import <Foundation/Foundation.h>
#import "AlivcBase.h"
/**
 * 一体化License基础接口
 */
OBJC_EXPORT
@interface AlivcLicense : NSObject

/**
 * 设置LicenseKey和LicenseFile
 * 通过控制台申请LicenseKey和LicenseFile https://help.aliyun.com/zh/vod/developer-reference/license-authorization-and-management
 * @param licenseKey 控制台申请的licenseKey
 * @param licenseFile 控制台申请的licenseFile，应用包的相对地址
 * @param env 国际化环境，一次进程只能同一个环境，不能中途修改
 * @param callback
 */
+ (void) ConfigWithLicenseKey:(NSString *)licenseKey
                  licenseFile:(NSString *)licenseFile
                          env:(AlivcGlobalEnv)env
                     callback:(void(^)(NSError *error))callback;

/**
 * 获取当前License内容
 */
+ (NSDictionary *) CurrentLicense;

/**
 * 检查当前License配置
 * @param callback 回调函数，如果配置正确，error为nil，否则为NSError
 */
+ (void) CheckLicense:(void(^)(NSError *error))callback;

@end

