//
//  AEPTransitionEffect.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/27.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AEPEffect.h"
#import "AliyunTransitionEffect.h"
#import "AliyunTransitionEffectTranslate.h"
#import "AliyunTransitionEffectShuffer.h"

/**
 转场效果的基类
 */
@interface AEPTransitionEffect : AEPEffect

/**
 转场时间，需要保证转场时间小于等于视频片段时长
 */
@property (nonatomic, assign, readonly) float overlapDuration;

/**
 编辑器用的转场对象
 */
@property (nonatomic, strong, readonly) AliyunTransitionEffect *editorEffect;

@end


/**
 百叶窗效果的转场
 */
@interface AEPTransitionShufferEffect : AEPTransitionEffect

/**
 百叶窗叶片宽度 范围是0.0-1.0
 */
@property (nonatomic, assign, readonly) float lineWidth;

/**
 平移方向属性
 */
@property (nonatomic, assign, readonly) ORIENTATION_TYPE orientation;
@end


/**
 平移效果的转场
 */
@interface AEPTransitionTranslateEffect : AEPTransitionEffect

/**
 移动方向
 */
@property (nonatomic, assign, readonly) DIRECTION_TYPE direction;
@end


/**
 多边形转场效果
 */
@interface AEPTransitionStarEffect : AEPTransitionEffect
@end


/**
 淡入淡出转场
 */
@interface AEPTransitionFadeEffect : AEPTransitionEffect
@end


/**
 圆形效果转场
 */
@interface AEPTransitionCircleEffect : AEPTransitionEffect
@end


/**
 自定义转场
 */
@interface AEPTransitionCustomEffect : AEPTransitionEffect

/**
 自定义转场资源
 */
@property (nonatomic, strong, readonly) AEPSource *source;
/**
 自定义转场参数
 */
@property (nonatomic, copy, readonly) NSString *paramString;

@end
