//
//  AliyunPcmRecordSource.h
//  AliyunVideoSDK
//
//  Created by coder.pi on 2024/7/8.
//

#import "AliyunAudioRecordController.h"
#import <AVFoundation/AVFoundation.h>
#import <CoreAudioTypes/CoreAudioTypes.h>

/**
 PCM数据格式 API_AVAILABLE(6.9.4)
 */
typedef NS_ENUM(NSInteger, AliyunRecorderPCMFormat) {
    AliyunRecorderPCMFormat_NONE = -1,
    AliyunRecorderPCMFormat_S16, ///< signed ,16 bit depth,one planar only
    AliyunRecorderPCMFormat_S32, ///< signed ,32 bit depth,one planar only
    AliyunRecorderPCMFormat_F32, ///< float ,32 bit depth ,one planar only
    
    AliyunRecorderPCMFormat_S16P, ///< signed,16 bit depth ,one planar per channel
    AliyunRecorderPCMFormat_S32P, ///< signed ,32 bit depth ,one planar per channel
    AliyunRecorderPCMFormat_F32P, ///< float ,32 bit depth ,one planar only
};

/**
 PCM录制源 API_AVAILABLE(6.9.4)
 */
@interface AliyunPcmRecordSource : NSObject<AliyunRecordDataSource>
/**
 PCM数据格式 API_AVAILABLE(6.9.4)
 */
@property (nonatomic, readonly) AliyunRecorderPCMFormat format;
/**
 频道数 API_AVAILABLE(6.9.4)
 */
@property (nonatomic, readonly) int channelCount;
/**
 采样率 API_AVAILABLE(6.9.4)
 */
@property (nonatomic, readonly) int sampleRate;

/**
 初始化PCM音频源 API_AVAILABLE(6.9.4)
 
 @param channelCount 频道数
 @param sampleRate 采样率
 */
- (instancetype) initWithChannelCount:(int)channelCount
                           sampleRate:(int)sampleRate;

/**
 添加音频数据 API_AVAILABLE(6.9.4)
 
 @param bufferList PCM音频数据
 @param format PCM数据格式
 @param frameCount 采样帧数
 @param error 错误信息
 @return 错误码, 0表示正常
 */
- (int) addAudioBufferList:(const AudioBufferList *)bufferList
                frameCount:(AVAudioFrameCount)frameCount
                 pcmFormat:(AliyunRecorderPCMFormat)format
                     error:(NSError **)error;
@end


/**
 PCM音频源控制器 API_AVAILABLE(6.9.4)
 */
@protocol AliyunPcmRecordController <AliyunAudioRecordController>
/**
 PCM音频源 API_AVAILABLE(6.9.4)
 */
@property (nonatomic, readonly) AliyunPcmRecordSource *pcmSource;
@end
