//
//  AliyunPipClip.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/8/10.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AliyunRenderModel.h"
#import "AliyunEffect.h"
#import "AliyunPureColorBorderInfo.h"

/** \addtogroup ugc_pip
 *  @{
 */

/**
 API_AVAILABLE(3.25.0)
 画中画片段类型
 */
typedef NS_ENUM(NSUInteger, AliyunPipClipType) {
    /**
     API_AVAILABLE(3.25.0)
     画中画视频
     */
    AliyunPipClipTypeVideo = 0,
    /**
     API_AVAILABLE(3.25.0)
     画中画图片
     */
    AliyunPipClipTypeImage = 1,
};

/**
 API_AVAILABLE(3.25.0)
 视频片段增强信息
 */
@interface AliyunClipAugmentationInfo : NSObject
/**
 API_AVAILABLE(3.25.0)
 亮度值
 */
@property(nonatomic, assign) float brightnessValue;
/**
 API_AVAILABLE(3.25.0)
 对比度值
 */
@property(nonatomic, assign) float contrastValue;
/**
 API_AVAILABLE(3.25.0)
 饱和度值
 */
@property(nonatomic, assign) float saturationValue;
/**
 API_AVAILABLE(3.25.0)
 锐度值
 */
@property(nonatomic, assign) float sharpnessValue;
/**
 API_AVAILABLE(3.25.0)
 暗角值
 */
@property(nonatomic, assign) float vignetteValue;
@end

/**
 API_AVAILABLE(3.25.0)
 片段音频信息
 */
@interface AliyunClipAudioInfo : NSObject
/**
 API_AVAILABLE(3.25.0)
 音量 [0~100]
 */
@property (nonatomic, assign) int volume;
/**
 API_AVAILABLE(3.25.0)
 降噪权值 [0~100]，取0表示关闭，值越大降噪越厉害
 */
@property (nonatomic, assign) int denoiseWeight;

/**
 API_AVAILABLE(3.25.0)
 音效
 */
@property (nonatomic, copy) AliyunAudioEffect *effect;
/**
 API_AVAILABLE(3.25.0)
 音频淡入效果
 */
@property (nonatomic, copy) AliyunAudioFade *fadeIn;
/**
 API_AVAILABLE(3.25.0)
 音频淡出效果
 */
@property (nonatomic, copy) AliyunAudioFade *fadeOut;
@end

/**
 API_AVAILABLE(3.25.0)
 画中画
 */
@interface AliyunPipClip : AliyunRenderModel<NSCopying>
/**
 API_AVAILABLE(3.25.0)
 流ID
 */
@property (nonatomic, assign, readonly) int streamId;
/**
 API_AVAILABLE(3.25.0)
 画中画类型
 */
@property (nonatomic, assign, readonly) AliyunPipClipType mediaType;
/**
 API_AVAILABLE(3.25.0)
 片段路径
 */
@property (nonatomic, copy, readonly) NSString *clipPath;
/**
 API_AVAILABLE(3.25.0)
 片段分辨率
 */
/**
 API_AVAILABLE(3.25.0)
 The resolution of clip
 */
@property (nonatomic, assign, readonly) CGSize clipResolution;
/**
 API_AVAILABLE(3.25.0)
 片段层级
 */
@property (nonatomic, assign, readonly) int zPosition;
/**
 API_AVAILABLE(3.25.0)
 缩放比
 */
@property (nonatomic, assign) CGFloat scale;

/**
 API_AVAILABLE(3.25.0)
 透明度
 */
@property (nonatomic, assign) CGFloat alpha;
/**
 API_AVAILABLE(3.25.0)
 原始显示大小，根据分辨率按照AliyunRenderMode_ResizeAspect模式计算得到
 */
@property (nonatomic, assign, readonly) CGSize originSize;
/**
 API_AVAILABLE(3.25.0)
 片段开始时间（截取开始时间）
 */
@property (nonatomic, assign) NSTimeInterval clipStartTime; // 暂时只支持从0开始
/**
 API_AVAILABLE(3.25.0)
 片段结束时间（截取结束时间）
 */
@property (nonatomic, assign) NSTimeInterval clipEndTime;
/**
 API_AVAILABLE(3.25.0)
 片段原始时长
 */
@property (nonatomic, assign, readonly) NSTimeInterval clipOriginDuration;
/**
 API_AVAILABLE(3.25.0)
 片段截取时长
 */
@property (nonatomic, assign, readonly) NSTimeInterval clipDuration;

/**
 API_AVAILABLE(3.31.0)
 是否水平翻转
 */
@property(nonatomic, assign) BOOL horizontalFlip;

/**
 API_AVAILABLE(3.25.0)
 纯色边框
 */
@property (nonatomic, strong) AliyunPureColorBorderInfo *border;
/**
 API_AVAILABLE(3.25.0)
 画面增强参数
 */
@property (nonatomic, strong, readonly) AliyunClipAugmentationInfo *augmentation;
/**
 API_AVAILABLE(3.25.0)
 音频参数
 */
@property (nonatomic, strong, readonly) AliyunClipAudioInfo *audio;

/**
 API_AVAILABLE(3.25.0)
 初始化函数
 
 @param type 画中画片段类型
 @param clipPath 画中画片段路径
 */
- (instancetype) initWithClipType:(AliyunPipClipType)type clipPath:(NSString *)clipPath;

/**
 获取所有动画action API_AVAILABLE(3.25.0)
 */
- (NSArray *)getAllActionList;

// MARK: - not support
- (void) setIsMirror:(BOOL)isMirror __attribute__((unavailable("not support mirror")));
- (void) setDuration:(NSTimeInterval)duration __attribute__((unavailable("please use ClipEndTime")));
@end

/** @}*/
