//  AliyunRecordSource.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/4/20.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>
#import <UIKit/UIKit.h>

/**
 录制源的媒体类型 API_AVAILABLE(3.22.0)
 */
typedef NS_ENUM(NSUInteger, AliyunRecordMediaType) {
    /**
     视频 API_AVAILABLE(3.22.0)
     */
    AliyunRecordMediaType_Video = 1 << 0,
    /**
     音频 API_AVAILABLE(3.22.0)
     */
    AliyunRecordMediaType_Audio = 1 << 1,
};

/**
 录制源类型 API_AVAILABLE(3.22.0)
 */
typedef NS_ENUM(NSUInteger, AliyunRecordSourceType) {
    /**
     数据流类型的录制源 API_AVAILABLE(3.22.0)
     */
    AliyunRecordSourceType_Data,
    /**
     文件类型的录制源 API_AVAILABLE(3.22.0)
     */
    AliyunRecordSourceType_File,
};

/**
 录制源协议 API_AVAILABLE(3.22.0)
 */
@protocol AliyunRecordSource <NSObject>
/**
 录制源的类型 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) AliyunRecordSourceType sourceType;
/**
 录制源的媒体类型 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) AliyunRecordMediaType mediaType;
/**
 是否正在采集 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) BOOL isRunning;
/**
  API_AVAILABLE(3.22.0)
 录制源准备
 例如摄像头、麦克风做一些权限申请
 */
- (BOOL) prepare;
/**
 开始采集 API_AVAILABLE(3.22.0)
 */
- (void) start;
/**
 停止采集 API_AVAILABLE(3.22.0)
 */
- (void) stop;
/**
  API_AVAILABLE(3.22.0)
 跳到指定时间，实时的录制源可忽略
 */
@end


@protocol AliyunRecordSource;
/**
 数据流的采集回调 API_AVAILABLE(3.22.0)
 */
@protocol AliyunRecordDataSourceDelegate <NSObject>
/**
 视频采集数据回调 API_AVAILABLE(3.22.0)
 */
- (BOOL) onAliyunRecordSource:(id<AliyunRecordSource>)source
         didOutputVideoBuffer:(CMSampleBufferRef)buffer
                displayMatrix:(CATransform3D)transform;

/**
 音频采集数据回调 API_AVAILABLE(3.22.0)
 */
- (BOOL) onAliyunRecordSource:(id<AliyunRecordSource>)source
         didOutputAudioBuffer:(CMSampleBufferRef)buffer;
@end


/**
 数据流类型的采集源 API_AVAILABLE(3.22.0)
 */
@protocol AliyunRecordDataSource <AliyunRecordSource>
/**
 数据流采集源的回调 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, weak) id<AliyunRecordDataSourceDelegate> dataSourceDelegate;
@end

/**
 文件类型的采集源 API_AVAILABLE(3.22.0)
 */
@protocol AliyunRecordFileSource <AliyunRecordSource>
/**
 文件路径 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) NSString *filePath;
/**
 从文件的什么位置开始（秒） API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) NSTimeInterval startTime;
/**
 参与采集的时间段 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) NSTimeInterval duration;

/**
 文件原始的音频时长 API_AVAILABLE(3.32.0)
 */
@property (nonatomic, readonly) NSTimeInterval originAudioDuration;

/**
 文件原始的视频时长 API_AVAILABLE(3.32.0)
 */
@property (nonatomic, readonly) NSTimeInterval originVideoDuration;
@end

/**
 动态帧率的协议 API_AVAILABLE(3.22.0)
 */
@protocol AliyunRecordSourceFPS <NSObject>
/**
 设置的帧率 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) int fps;
/**
 最大能达到的帧率 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) int maxFPS;
/**
 真实的帧率 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) int realFPS;
@end
