//
//  AliyunEditorRenderWrapper.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/9/24.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, AliyunEditorRenderViewMode) {
    /**
     不等比拉伸填充 API_AVAILABLE(3.25.0)
     */
    AliyunEditorRenderViewModeResize,
    /**
     等比拉伸留白 API_AVAILABLE(3.25.0)
     */
    AliyunEditorRenderViewModeResizeAspect,
};

@class AliyunEditorRenderWrapper;
/**
 编辑器内容视图回调 API_AVAILABLE(3.25.0)
 */
@protocol AliyunEditorRenderWrapperDelegate <NSObject>
@optional
/**
 编辑器内容视图位置大小发生改变 API_AVAILABLE(3.25.0)
 */
- (void) onAliyunEditorRenderWrapper:(AliyunEditorRenderWrapper *)renderWrapper frameDidChange:(CGRect)frame;
@end

/**
 编辑器内容视图 API_AVAILABLE(3.25.0)
 */
@interface AliyunEditorRenderWrapper : NSObject
/**
 视图回调事件 API_AVAILABLE(3.25.0)
 */
@property (nonatomic, weak) id<AliyunEditorRenderWrapperDelegate> delegate;

/**
 渲染模式 API_AVAILABLE(3.25.0)
 */
@property (nonatomic, assign) AliyunEditorRenderViewMode renderMode;
/**
 视图位置大小 API_AVAILABLE(3.25.0)
 */
@property (nonatomic, readonly) CGRect frame;
/**
 渲染区域的大小 API_AVAILABLE(3.25.0)
 */
@property (nonatomic, readonly) CGSize renderSize;

/**
 把相对当前视图的点转换到其他视图 API_AVAILABLE(3.25.0)
 */
- (CGPoint)convertPoint:(CGPoint)point toView:(UIView *)view;
/**
把相对其他视图的点转换到当前视图 API_AVAILABLE(3.25.0)
 */
- (CGPoint)convertPoint:(CGPoint)point fromView:(UIView *)view;
/**
 把相对当前视图的位置大小转换到其他视图 API_AVAILABLE(3.25.0)
 */
- (CGRect)convertRect:(CGRect)rect toView:(UIView *)view;
/**
 把相对其他视图的位置大小转换到当前视图 API_AVAILABLE(3.25.0)
 */
- (CGRect)convertRect:(CGRect)rect fromView:(UIView *)view;
@end
