//
//  AliyunFilterManager.h
//  AliyunVideoSDKPro
//
//  Created by mengyehao on 2021/11/15.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "AliyunShaderFilterController.h"
#import "AliyunLutFilterController.h"

/**
 API_AVAILABLE(3.27.0)
 滤镜管理器
 */
@interface AliyunFilterManager : NSObject

/**
 API_AVAILABLE(3.27.0)
 添加lut滤镜
 
 @param path lut图片的路径
 @param intensity 滤镜的强度，[0.0,1.0]
 @return AliyunLutFilterController, lut滤镜控制器
 */
- (AliyunLutFilterController *)applyLutFilterWithPath:(NSString *)path
                                            intensity:(float)intensity;
/**
 API_AVAILABLE(3.27.0)
 添加滤镜
 
 @param path 路径资源文件夹路径
 @return AliyunShaderFilterController, 滤镜控制器
 */
- (AliyunShaderFilterController *)applyShadeFilterWithPath:(NSString *)path;

/**
 API_AVAILABLE(3.27.0)
 删除滤镜
 
 @param filterController 要删除的滤镜，传入AliyunBaseFilterController的具体子类
 @return 0 表示成功
 */
- (int)removeFilter:(AliyunBaseFilterController *)filterController;

/**
 API_AVAILABLE(3.27.0)
 获取lut滤镜控制器
 
 @return 一个包含AliyunLutFilterController的列表，目前只有一个
 */
- (NSArray<AliyunLutFilterController *> *)getLutFilterControllers;

/**
 API_AVAILABLE(3.27.0)
 获取滤镜控制器
 
 @return 一个包含AliyunShaderFilterController的列表，目前只有一个
 */
- (NSArray<AliyunShaderFilterController *> *)getShaderFilterControllers;

@end


