//
//  AliyunPipManager.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/8/12.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunPipTrackController.h"

/**
 *  @defgroup ugc_pip 画中画
 *  @ingroup ugc_editor
 *  @{
 */

/** @} */ // end of ugc_editor

/** \addtogroup ugc_pip
 *  @{
 */
/**
 API_AVAILABLE(3.25.0)
 画中画管理器
 */
@interface AliyunPipManager : NSObject
/**
 API_AVAILABLE(3.25.0)
 画中画轨道控制器
 */
@property (nonatomic, copy, readonly) NSArray<AliyunPipTrackController *> *trackControllers;

/**
 API_AVAILABLE(3.25.0)
 添加画中画
 
 @param type 画中画类型
 @param path 画中画资源路径
 @param error 输出参数，错误信息，没有错误为nil
 @return 画中画片段控制器
 */
- (AliyunPipClipController *) addClipWithType:(AliyunPipClipType)type path:(NSString *)path error:(NSError **)error;

/**
 API_AVAILABLE(3.25.0)
 添加画中画到指定轨道
 
 @param clip 画中画对象
 @param track 指定轨道，如果传入空表示新增一条轨道
 @param error 输出参数，错误信息，没有错误为nil
 @return 画中画片段控制器
 */
- (AliyunPipClipController *) addClipWithModel:(AliyunPipClip *)clip
                                       toTrack:(AliyunPipTrackController *)track
                                         error:(NSError **)error;

/**
 API_AVAILABLE(3.25.0)
 删除画中画片段
 
 @param clipController 画中画片段控制器
 @param error 输出参数，错误信息，没有错误为nil.
 @return 成功或失败
 */
- (BOOL) removePipClipController:(AliyunPipClipController *)clipController error:(NSError **)error;

/**
 API_AVAILABLE(3.25.0)
 移动画中画片段
 
 @param clipController 需要移动的的片段控制器
 @param toTrack 目标画中画轨
 @param startTime 开始时间
 @return 成功或失败
 */
- (BOOL) movePipClipController:(AliyunPipClipController *)clipController
                       toTrack:(AliyunPipTrackController *)toTrack
                 withStartTime:(NSTimeInterval)startTime;

/**
 API_AVAILABLE(3.25.0)
 点击测试，返回点击命中的画中画控制器
 
 @param point 测试点击的点
 @param time 测试点击的时间轴时间点
 @return 返回满足最上层满足要求的画中画片段控制器
 */
- (AliyunPipClipController *) hitTest:(CGPoint)point withTime:(NSTimeInterval)time;
@end

/** @}*/
