//
//  AEPEffect.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPSource.h"

#import "AliyunEffect.h"
#import "AliyunEffectBlurBackground.h"
#import "AliyunEffectRunningDisplayMode.h"

/**
 特效基类
 */
@interface AEPEffect : NSObject

/**
 特效ID
 */
@property (nonatomic, assign, readonly) int effectId;

@end


/**
 变声特效
 */
@interface AEPAudioEffect : AEPEffect

/**
 音效类型
 */
@property (nonatomic, assign, readonly) AliyunAudioEffectType effectType;

/**
 音效值0-100
 */
@property (nonatomic, assign, readonly) int effectParam;

/**
 编辑器音效对象
 */
@property (nonatomic, strong, readonly) AliyunAudioEffect *editorEffect;

@end


/**
 音频淡入淡出Model
 */
@interface AEPAudioFadeEffect : AEPEffect

/**
 淡入或者淡出
 */
@property (nonatomic, assign, readonly) BOOL fadeIn;

/**
 曲线
 */
@property (nonatomic, assign, readonly) AliyunAudioFadeShape shapeType;

/**
 时长（单位：秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval duration;

/**
 编辑器的音效对象
 */
@property (nonatomic, strong, readonly) AliyunAudioFade *editorEffect;

@end


/**
 背景模糊效果model类
 */
@interface AEPBlurBackgroundEffect : AEPEffect

/**
 片段内部开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval clipIn;
/**
 片段内部结束时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval clipOut;
/**
 模糊半径

 数值越大越模糊，范围0-29
 */
@property (nonatomic, assign, readonly) float blurRadius;

/**
 编辑器的背景模糊对象
 */
@property (nonatomic, strong, readonly) AliyunEffectBlurBackground *editorEffect;

@end
