#ifndef AVPDrmDelegate_h
#define AVPDrmDelegate_h

#import <Foundation/Foundation.h>

@protocol AVPDrmDelegate <NSObject>

/**
 @brief 起播过程中请求Fairplay证书的回调方法。
 @param player 播放器player指针
 @return 证书数据，请参考Fairplay提供商文档实现证书数据的解析（如某些厂商会把证书内容包在json内）。
 */
- (NSData *)requestCert:(AliPlayer*)player;

/**
 @brief 起播过程中请求Fairplay密钥的回调方法。
 @param data: 请求Fairplay密钥的必要参数，请参考Fairplay提供商文档实现密钥的请求（如某些提供商会要求携带额外参数）。
 @return 该播放地址对应的解密密钥，请参考Fairplay提供商文档实现密钥的解析（如某些提供商会把密钥密钥内容包在json内）。
 */
- (NSData *)requestKey:(AliPlayer*)player data:(NSData *)data;

@end

#endif /* AVPDrmDelegate_h */
