//
//  AliyunResourceLoadTask.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/11/11.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunResourceModel.h"

/**
 资源加载任务
 API_AVAILABLE(3.27.0)
 */
@interface AliyunResourceLoadTask : NSObject

/**
 任务是否完成
 */
@property (nonatomic, assign, readonly) BOOL isFinish;

/**
 任务原始资源
 */
@property (nonatomic, strong, readonly) AliyunResourceModel *resource;

/**
 加载这个任务成功，并返回源
 
 @param source 新资源的源实例
 */
- (void) onSuccess:(AEPSource *)source;

/**
 忽略这次加载任务
 */
- (void) onIgnore;

/**
 加载这个任务失败
 
 @param error 加载失败的错误
 */
- (void) onFail:(NSError *)error;

@end
