//
//  AliyunResourceTaskManager.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/11/16.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AliyunResourceLoadTask.h"

/**
 资源加载任务管理器
 API_AVAILABLE(3.27.0)
 */
@interface AliyunResourceTaskManager : NSObject

/**
 资源加载任务定义
 */
@property (nonatomic, copy) void(^resourceLoadTasksCallback)(id taskManager, NSArray<AliyunResourceLoadTask *> *tasks);

@end

/**
 资源导出任务管理器
 API_AVAILABLE(3.27.0)
 */
@interface AliyunResourceExport : AliyunResourceTaskManager


@end


/**
 资源导入任务管理器
 API_AVAILABLE(3.27.0)
 */
@interface AliyunResourceImport : AliyunResourceTaskManager


@end
