//
//  AEPEffectTrack.h
//  AliyunVideoSDKPro
//
//  Created by Bingo on 2021/5/19.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AEPTrack.h"

#import "AliyunEffectMV.h"
#import "AliyunEffectFilter.h"
#import "AliyunEffectTimeFilter.h"
#import "AliyunShaderFilterController.h"
#import "AliyunLutFilterController.h"

@interface AEPEffectTrack : AEPTrack
@end

/**
 时间特效类型

 - AEPEffectTimeType_Speed: 变速
 - AEPEffectTimeType_Repeat: 反复
 - AEPEffectTimeType_Invert: 倒放
 */
typedef NS_ENUM(NSUInteger, AEPEffectTimeType) {
    AEPEffectTimeType_None      = 0,
    AEPEffectTimeType_Speed     = 1,
    AEPEffectTimeType_Repeat    = 2,
    AEPEffectTimeType_Invert    = 3,
};


@interface AEPEffectTimeTrack : AEPEffectTrack

/**
 时间特效类型
 */
@property (nonatomic, assign, readonly) AEPEffectTimeType timeType;

/**
 时间特效参数

 1.在变速类型下代表速率，范围建议 0.5 - 2
 2.在反复类型下代表反复次数，内部取整型
 */
@property (nonatomic, assign, readonly) float timeParam;

/**
 时间线上的开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineIn;

/**
 时间线上的结束时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineOut;

/**
 是否保留播放轴时长

 举例：如果10s视频，全程慢速2倍，如果originDuration为YES，则播放轴为10s，如果为NO,则播放轴为20s。
 */
@property (nonatomic, assign, readonly) BOOL needOriginDuration;

/**
 在编辑器中使用的特效对象
 */
@property (nonatomic, strong, readonly) AliyunEffectTimeFilter *editorEffect;

@end

/**
 滤镜效果model类
 */
@interface AEPEffectFilterTrack : AEPEffectTrack

/**
 滤镜资源
 */
@property (nonatomic, strong, readonly) AEPSource *source;

/**
 时间线上的开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineIn;

/**
 时间线上的结束时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineOut;
/**
 编辑器用到的滤镜对象
 */
@property (nonatomic, strong, readonly) AliyunEffectFilter *editorEffect;

@end

/**
 特效
 */
@interface AEPEffectAnimationFilterTrack : AEPEffectFilterTrack
/**
 特效参数
 */
@property (nonatomic, copy, readonly) NSString *paramString;
@end

/**
 mv效果model类
 */
@interface AEPEffectMVTrack : AEPEffectTrack

/**
 MV资源
 */
@property (nonatomic, strong, readonly) AEPSource *source;

/**
 时间线上的开始时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineIn;

/**
 时间线上的结束时间（秒）
 */
@property (nonatomic, assign, readonly) NSTimeInterval timelineOut;

/**
 流ID
 */
@property (nonatomic, assign, readonly) int audioStreamId;

/**
 是否静音
 */
@property (nonatomic, assign, readonly) BOOL mute;

/**
 混音权重
 */
@property (nonatomic, assign, readonly) int mixWeight;

/**
 降噪权重
 */
@property (nonatomic, assign, readonly) int denoiseWeight;

/**
 效果列表
 */
@property (nonatomic, copy, readonly) NSArray<AEPEffect *> *effects;

/**
 音效
 */
@property (nonatomic, strong, readonly) AEPAudioEffect *audioEffect;

/**
 淡入Model
 */
@property (nonatomic, strong, readonly) AEPAudioFadeEffect *fadeInEffect;
/**
 淡出Model
 */
@property (nonatomic, strong, readonly) AEPAudioFadeEffect *fadeOutEffect;

/**
 编辑器中使用的MV对象
 */
@property (nonatomic, strong, readonly) AliyunEffectMV *editorEffect;

@end


/**
 Shader滤镜效果model类
 */
@interface AEPEffectShaderFilterTrack : AEPEffectFilterTrack

/**
 编辑器用到的滤镜对象
 */
@property (nonatomic, strong, readonly) AliyunShaderFilterController *nativeFilterController;

@end



/**
 Lut滤镜效果model类
 */
@interface AEPEffectLutFilterTrack : AEPEffectFilterTrack

/**
 lut滤镜强度
 */
@property (nonatomic, assign, readonly) float intensity;

/**
 编辑器用到的滤镜对象
 */
@property (nonatomic, strong, readonly) AliyunLutFilterController *nativeFilterController;

@end

