//
//  AEPResourceModel.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/7/30.
//  Copyright © 2021 aliyun. All rights reserved.
//

#import "AliyunResourceModel.h"

/**
 资源节点模块
 */
typedef NS_ENUM(NSUInteger, AEPResourceModule) {
    AEPResourceModule_Unkown,
    /**
     封面
     */
    AEPResourceModule_Cover,
    
    /**
     主视频轨道
     */
    AEPResourceModule_MainVideo,
    
    /**
     画中画轨道
     */
    AEPResourceModule_Pip,

    /**
     主轨道的音乐
     */
    AEPResourceModule_Music,
    /**
     主轨道的配音
     */
    AEPResourceModule_Dub,
    
    /**
     翻转字幕
     */
    AEPResourceModule_RollCaption,
    /**
     纯文字
     */
    AEPResourceModule_Subtitle,
    /**
     气泡字
     */
    AEPResourceModule_Bubble,
    /**
     花字
     */
    AEPResourceModule_Caption,
   
    /**
     贴纸
     */
    AEPResourceModule_Sticker,

    /**
     MV
     */
    AEPResourceModule_MV,
    /**
     滤镜
     */
    AEPResourceModule_Filter,
    /**
     lut滤镜
     */
    AEPResourceModule_LutFilter,
    /**
     特效
     */
    AEPResourceModule_AnimationFilter,
    
    /**
     转场
     */
    AEPResourceModule_Transition,
    
    /**
     涂鸦
     */
    AEPResourceModule_Paint,
    /**
     水印
     */
    AEPResourceModule_Watermark,
    /**
     尾部水印
     */
    AEPResourceModule_TailWatermark,
    
    /**
     模板
     */
    AEPResourceModule_Template,
};

/**
 资源数据模型
 */
@interface AEPResourceModel : AliyunResourceModel

/**
 资源节点所在的模块
 */
@property (nonatomic, assign, readonly) AEPResourceModule module;

/**
 使用该资源的工程节点
 */
@property (nonatomic, strong, readonly) id aepNode;

@end
