//
//  AliyunRecorderConfig.h
//  AliyunVideoSDKPro
//
//  Created by coder.pi on 2021/4/26.
//  Copyright © 2021 aliyun. All rights reserved.
//

#ifndef AliyunRecorderConfig_h
#define AliyunRecorderConfig_h

#import "AliyunVideoParam.h"
#import "AliyunRecorderSticker.h"
#import "AliyunCameraRecordSource.h"
#import "AliyunViewRecordSource.h"
#import "AliyunAudioRecordController.h"
#import "AliyunMicRecordSource.h"
#import "AliyunPcmRecordSource.h"
#import "AliyunPlayerRecordSource.h"
#import "AliyunFileRecordSource.h"

/**
 编码模式 API_AVAILABLE(3.22.0)
 */
typedef NS_ENUM(NSUInteger, AliyunRecorderEncodeMode) {
    /**
     硬编码 API_AVAILABLE(3.22.0)
     */
    AliyunRecorderEncodeMode_HardCoding,
    /**
     软编码 API_AVAILABLE(3.22.0)
     */
    AliyunRecorderEncodeMode_SoftCoding,
};


/**
 回声消除模式 API_AVAILABLE(6.9.4)
 */
typedef NS_ENUM(NSUInteger, AliyunRecorderAECMode) {
    /**
    关闭回声消除 API_AVAILABLE(6.9.4)
     */
    AliyunRecorderAECMode_NoAEC,
    /**
     软件回声消除 API_AVAILABLE(6.9.4)
     */
    AliyunRecorderAECMode_Software,
    /**
     硬件回声消除 API_AVAILABLE(6.9.4)
     */
    AliyunRecorderAECMode_Hardware,
};

/**
 视频配置参数 API_AVAILABLE(3.22.0)
 */
@interface AliyunRecorderVideoConfig : NSObject
/**
 编码模式，默认为硬编码 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) AliyunRecorderEncodeMode encodeMode;
/**
 旋转角度 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) int rotate;
/**
 分辨率；默认为 720x1280 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) CGSize resolution;
/**
 裁剪模式；默认为AliyunScaleModeFit API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) AliyunScaleMode scaleMode;
/**
 码率 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) int bitrate;
/**
 视频质量；默认为 AliyunVideoQualityHight API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) AliyunVideoQuality videoQuality;
/**
 关键帧间隔 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) int gop;
/**
 帧率 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) int fps;

/**
 参数是否有效 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) BOOL isValid;
@end

/**
 背景图信息 API_AVAILABLE(3.22.0)
 */
@interface AliyunRecorderBackgroundInfo : NSObject
/**
 背景颜色 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, strong) UIColor *color;
/**
 背景图片 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, strong) UIImage *image;
/**
 渲染模式 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, assign) AliyunRenderMode renderMode;
@end


/**
 录制的配置 API_AVAILABLE(3.22.0)
 */
@interface AliyunRecorderConfig : NSObject
/**
 输出MP4的文件路径 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, copy) NSString *outuptPath;
/**
 录制任务临时路径 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) NSString *taskPath;

/**
 是否使用硬件回声消除 API_AVAILABLE(3.27.0)
 */
@property (nonatomic, readonly) BOOL isUsingAEC __deprecated_msg("please use aecMode");

/**
 回声消除模式 API_AVAILABLE(6.9.4)
 */
@property (nonatomic, readonly) AliyunRecorderAECMode aecMode;

/**
 输出视频配置 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) AliyunRecorderVideoConfig *videoConfig;
/**
 背景信息 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, strong) AliyunRecorderBackgroundInfo *bgInfo;

/**
 麦克风控制器 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) id<AliyunMicRecordController> microphoneController;
/**
 背景音乐控制器 API_AVALIABLE(3.27.0)
 */
@property (nonatomic, readonly) id<AliyunAudioRecordController> bgmController;
/**
 摄像头控制器 API_AVALIABLE(3.27.0)
 */
@property (nonatomic, readonly) id<AliyunCameraRecordController> cameraController;
/**
 视图控制器 API_AVALIABLE(3.27.0)
 */
@property (nonatomic, readonly) NSArray<id<AliyunViewRecordController>> *viewSourceControllers;
/**
 视频控制器 API_AVALIABLE(3.27.0)
 */
@property (nonatomic, readonly) NSArray<id<AliyunPlayerRecordController>> *playerSourceControllers;
/**
 合拍视频控制器 API_AVALIABLE(3.29.0)
 */
@property (nonatomic, readonly) NSArray<id<AliyunAVFileRecordController>> *avSourceControllers;

/**
 PCM控制器 API_AVALIABLE(6.9.4)
 */
@property (nonatomic, readonly) NSArray<id<AliyunPcmRecordController>> *pcmSourceControllers;

/**
 初始化 API_AVAILABLE(3.27.0)
 
 @param videoConfig 输出视频配置
 @param outputPath 最终输出mp4路径
 @param usingAEC 是否使用回声消除
 */
- (instancetype) initWithVideoConfig:(AliyunRecorderVideoConfig *)videoConfig
                          outputPath:(NSString *)outputPath
                            usingAEC:(BOOL)usingAEC __deprecated_msg("please use initWithVideoConfig:outputPath:aecMode:");

/**
 初始化 API_AVAILABLE(6.9.4)
 
 @param videoConfig 输出视频配置
 @param outputPath 最终输出mp4路径
 @param aecMode 回声消除模式
 */
- (instancetype) initWithVideoConfig:(AliyunRecorderVideoConfig *)videoConfig
                          outputPath:(NSString *)outputPath
                             aecMode:(AliyunRecorderAECMode)aecMode;

/**
 初始化 API_AVAILABLE(3.22.0)
 使用回声消除
 
 @param videoConfig 输出视频配置
 @param outputPath 最终输出mp4路径
 */
- (instancetype) initWithVideoConfig:(AliyunRecorderVideoConfig *)videoConfig
                          outputPath:(NSString *)outputPath;

/**
 API_AVAILABLE(3.22.0)
 添加摄像头源（只能添加一个，多次调用返回同一个控制器）
 @param layout 摄像头源在输出视频的位置布局
 */
- (id<AliyunCameraRecordController>) addCamera:(AliyunVideoRecordLayoutParam *)layout;


/**
 API_AVAILABLE(6.9.2)
 添加摄像头源（只能添加一个，多次调用返回同一个控制器）
 @param layout 摄像头源在输出视频的位置布局
 */
- (id<AliyunCameraRecordController>) addCamera:(AliyunVideoRecordLayoutParam *)layout pixelFormat:(AliyunRecordCameraPixelFormat)pixelFormat;

/**
 移除摄像头源 API_AVAILABLE(3.27.0)
 */
- (BOOL) removeCamera;
/**
 添加视图源 API_AVAILABLE(3.22.0)
 
 @param source 视图源
 @param layout 视图源在输出视频的位置布局
 */
- (id<AliyunViewRecordController>) addViewSource:(AliyunViewRecordSource *)source
                                          layout:(AliyunVideoRecordLayoutParam *)layout;

/**
 移除视图源 API_AVAILABLE(3.27.0)
 
 @param sourceController 视图源控制器
 */
- (BOOL) removeViewSource:(id<AliyunViewRecordController>)sourceController;


/**
 添加合拍源 API_AVAILABLE(3.29.0)
 
 @param source 合拍源
 @param layout 合拍源在输出视频的位置布局
 */
- (id<AliyunAVFileRecordController>) addAVFileSource:(AliyunFileRecordSource *)source
                                              layout:(AliyunVideoRecordLayoutParam *)layout;

/**
 移除合拍源 API_AVAILABLE(3.29.0)
 
 @param sourceController 合拍源控制器
 */
- (BOOL) removeAVFileSource:(id<AliyunAVFileRecordController>)sourceControler;

/**
 添加麦克风源，默认添加 API_AVAILABLE(3.27.0)
 */
- (id<AliyunMicRecordController>) addMicrophone;

/**
 移除麦克风源 API_AVAILABLE(3.27.0)
 */
- (BOOL) removeMicrophone;

/**
 添加PCM音频源
 */
- (id<AliyunPcmRecordController>) addPCMSource:(AliyunPcmRecordSource *)source;

/**
 移除PCM音频源
 */
- (BOOL) removePCMSource:(id<AliyunPcmRecordController>)sourceController;

/**
 设置背景音乐 API_AVAILABLE(3.22.0)
 
 @param filePath 背景音乐文件
 @param startTime 从哪里开始截取背景音乐
 @param duration 截取多长的音乐
 */
- (id<AliyunAudioRecordController>) setBgMusicWithFile:(NSString *)filePath
                                             startTime:(NSTimeInterval)startTime
                                              duration:(NSTimeInterval)duration;

/**
 移除背景音乐 API_AVAILABLE(3.22.0)
 */
/**
 remove background music API_AVAILABLE(3.22.0)
 */
- (BOOL) removeBgMusic;

/**
 添加水印 API_AVAILABLE(3.22.0)
 
 @param waterMark 水印
 */
- (void) addWaterMark:(AliyunRecorderImageSticker *)waterMark;

/**
 移除水印 API_AVAILABLE(3.22.0)
 
 @param waterMarkId 贴纸的ID
 */
- (void) removeWaterMark:(int)waterMarkId;

@end

// MARK: - deprecated. It is not recommended to use the following methods.
@interface AliyunRecorderConfig (Deprecated)
/**
 添加合拍源 API_AVAILABLE(3.27.0)
 
 @param source 合拍源
 @param layout 合拍源在输出视频的位置布局
 */
- (id<AliyunPlayerRecordController>) addPlayerSource:(AliyunPlayerRecordSource *)source
                                              layout:(AliyunVideoRecordLayoutParam *)layout __deprecated_msg("please use addAVFileSource:");

/**
 移除合拍源 API_AVAILABLE(3.27.0)
 
 @param sourceController 合拍源控制器
 */
- (BOOL) removePlayerSource:(id<AliyunPlayerRecordController>)sourceController __deprecated_msg("please use removeAVFileSource:");

/**
 视频控制器 API_AVAILABLE(3.22.0)
 */
@property (nonatomic, readonly) NSArray<id<AliyunVideoBaseRecordController>> *videoRecordControllers __deprecated_msg("please use cameraController, playerSourceControllers, viewSourceControllers");

/**
 删除视频源 API_AVAILABLE(3.22.0)
 
 @param videoId 视频源唯一标识，对应controller里的videoId
 */
- (BOOL) removeVideo:(int)videoId __deprecated_msg("please use removeCamera, removePlayerSource:, removeViewSource:");
@end

#endif /* AliyunRecorderConfig_h */
