"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var validCheck_1 = require("./validCheck");
var isTypedArray_1 = __importDefault(require("../isTypedArray"));
var hasOwnProperty = Object.prototype.hasOwnProperty;
function getSkip(isArr, value) {
    var isArg = !isArr && (0, validCheck_1.isArguments)(value);
    var isBuff = !isArr && !isArg && false;
    var isType = !isArr && !isArg && !isBuff && (0, isTypedArray_1.default)(value);
    return isArr || isArg || isBuff || isType;
}
function arrayLikeKeys(value, inherited) {
    var isArr = Array.isArray(value);
    var skipIndexes = getSkip(isArr, value);
    var length = value.length;
    var result = new Array(skipIndexes ? length : 0);
    var index = skipIndexes ? -1 : length;
    while (++index < length) {
        result[index] = "".concat(index);
    }
    for (var key in value) {
        if ((inherited || hasOwnProperty.call(value, key))
            && !(skipIndexes && ((key === 'length'
                || (0, validCheck_1.isIndex)(key, length))))) {
            result.push(key);
        }
    }
    return result;
}
exports.default = arrayLikeKeys;
